package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.SchemeQueryRecord;
import cn.wisenergy.model.app.Volunteer;
import cn.wisenergy.model.vo.SchemeRecordQueryVo;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface SchemeRecordService {
    /**
     * 添加方案查询记录
     *
     * @param schemeQueryRecord 方案信息
     * @return 方案信息
     */
    R<SchemeQueryRecord> add(SchemeQueryRecord schemeQueryRecord);

    /**
     * 获取方案查询列表
     *
     * @param schemeRecordQueryVo 查询条件
     * @return 方案查询列表
     */
    R<PageInfo<SchemeQueryRecord>> getList(SchemeRecordQueryVo schemeRecordQueryVo);

    /**
     * 获取用户方案志愿列表
     * @param userId 用户id
     * @param recordId 方案记录id
     * @return 方案志愿列表
     */
    R<List<Volunteer>> getVolunteerList(Integer userId,Integer recordId);

    /**
     * 方案pdf导出
     * @param userId 用户id
     * @param recordId 方案查询记录id
     * @return 0：导出成功，1：导出失败
     */
    R<Boolean> export(Integer userId, Integer recordId, HttpServletResponse response);

    /**
     * 方案excel导出
     * @param userId 用户id
     * @param recordId 方案查询记录id
     * @return 0：导出成功，1：导出失败
     */
    R<Boolean> createExcel(Integer userId, Integer recordId, HttpServletResponse response);
}
