package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.SchemeInfo;
import cn.wisenergy.model.vo.SchemeQueryVo;
import cn.wisenergy.model.vo.SchemeVipVo;
import cn.wisenergy.model.vo.SchemeVo;
import cn.wisenergy.model.vo.VolunteerVo;
import com.github.pagehelper.PageInfo;

import java.util.List;


/**
 * @ Description: 方案接口定义
 * @ Author     : 86187
 * @ Date       : 2021/1/13 14:50
 */
public interface SchemeService {

    /**
     * 方案查询
     *
     * @param schemeVo 查询参数
     * @return 方案查询结果列表
     */
    R<VolunteerVo> getList(SchemeVo schemeVo);


    /**
     * 根据方案id，删除方案
     *
     * @param schemeId 方案id
     * @return
     */
    R<Boolean> deleteById(Integer schemeId);

    /**
     * 方案列表查询
     *
     * @param schemeVo 查询参数
     * @return 方案查询结果列表
     */
    R<PageInfo<SchemeInfo>> getSchemeList(SchemeQueryVo schemeVo);

    /**
     * 获取方案下载路径
     *
     * @param schemeId 方案id
     * @return 方案下载路径
     */
    R<String> download(Integer schemeId);

    List<Integer>  ceishi(Integer id);

    /**
     * 私人订制方案查询
     *
     * @param schemeVo 查询参数
     * @return 方案查询结果列表
     */
    R<VolunteerVo> getListVip(SchemeVipVo schemeVo);
}
