package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.dto.PayPageDto;
import cn.wisenergy.model.dto.PayQueryDto;

import javax.crypto.IllegalBlockSizeException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;

/**
 * @author 86187
 */
public interface WxPayService1 {

    /**
     * 微行支付接口
     * @param payPageDto 入参
     * @return
     */
    R<String> wxPay(PayPageDto payPageDto) throws UnsupportedEncodingException, NoSuchAlgorithmException, SignatureException, InvalidKeySpecException, InvalidKeyException;


    /**
     * 微信支付-交易查询
     * @param payQueryDto 入参
     * @return
     */
    R<String> queryWx(PayQueryDto payQueryDto) throws UnsupportedEncodingException, NoSuchAlgorithmException, SignatureException, InvalidKeySpecException, InvalidKeyException;


    R<String> wx_Pay(PayPageDto payPageDto) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeySpecException, InvalidKeyException, IllegalBlockSizeException;

}
