package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.Md5Util;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.AccountMapper;
import cn.wisenergy.model.app.AccountInfo;
import cn.wisenergy.model.dto.AccountDto;
import cn.wisenergy.model.enums.LonginType;
import cn.wisenergy.model.vo.AccountLoginVo;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.service.app.AccountSerivce;
import cn.wisenergy.service.util.UserToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.HashMap;

@Slf4j
@Service
public class AccountSerivceImpl implements AccountSerivce {

    @Autowired
    private AccountMapper accountMapper;
    private static final String ADMIN_LOGIN_TYPE = LonginType.ADMIN.getDescription();

    @Override
    public R<AccountDto> getAccountInfo(AccountLoginVo accountLoginVo) {
        log.info("AccountSerivceImpl[].getAccountInfo[].input.param:accountLoginVo:"+accountLoginVo);

        if (null==accountLoginVo) {
            return R.error("账号或密码为空");
        }
        //判断参数是否为空
        if (StringUtils.isEmpty(accountLoginVo.getUserName())||StringUtils.isEmpty(accountLoginVo.getPassword())) {
            return R.error("账号或密码为空");
        }
        Subject subject = SecurityUtils.getSubject();
        UserToken userToken = new UserToken(accountLoginVo.getUserName(), accountLoginVo.getPassword(), ADMIN_LOGIN_TYPE);
        //UsernamePasswordToken token = new UsernamePasswordToken(accountLoginVo.getUserName(),accountLoginVo.getPassword(),"admin" );

        /*//创建参数容器map
        HashMap<String, Object> map = new HashMap<>(4);
        map.put("userName",accountLoginVo.getUserName());

        //查询管理者信息
        AccountInfo accountInfo = accountMapper.getAccountInfo(map);
        if (null==accountInfo) {
            return R.error("用户不存在");
        }

        //将加密过后的密码与传输数据进行比较
        String s = Md5Util.digestMD5(accountInfo.getPassword());
        if (!accountLoginVo.getPassword().equals(s)) {
            return R.error("密码或者用户名错误");
        }
        //查询超过则进行数据copy
        AccountDto accountDto = new AccountDto();
        BeanUtils.copyProperties(accountInfo,accountDto);*/
        //返回数据
        try {
            subject.login(userToken);
            AccountDto accountDto = new AccountDto();
            AccountInfo info=(AccountInfo)SecurityUtils.getSubject().getPrincipal();
            accountDto.setId(info.getId());
            accountDto.setUserName(info.getUserName());
            accountDto.setSessionId(subject.getSession().getId().toString());
            return R.ok(0, accountDto);
        } catch (IncorrectCredentialsException e) {
            return R.error(1, "账户密码错误");
        } catch (LockedAccountException e) {
            return R.error(1, "登录失败!请联系管理员");
        } catch (AuthenticationException e) {
            return R.error(1, "该用户不存在");
        } catch (Exception e) {
            return R.error(1, "系统异常");
        }
    }
}
