package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.constant.CommonAttributes;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.PayRecordMapper;
import cn.wisenergy.model.app.PayRecord;
import cn.wisenergy.model.vo.PayRecordQueryVo;
import cn.wisenergy.model.vo.PayRecordShowVo;
import cn.wisenergy.service.app.PayRecordService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ Description: 充值记录实现
 * @ Author     : 86187
 * @ Date       : 2021/1/13 17:18
 * @author 86187
 */
@Service
@Slf4j
public class PayRecordServiceImpl extends ServiceImpl<PayRecordMapper, PayRecord> implements PayRecordService {

    @Autowired
    private PayRecordMapper payRecordMapper;


    @Override
    public R<PageInfo<PayRecordShowVo>> getList(PayRecordQueryVo queryVo) {
        log.info("volunteer-service[]PayRecordServiceImpl[]getList[]input.param.queryVo:" + queryVo);
        if (null == queryVo || null == queryVo.getUserId()) {
            return R.error("参数不能为空!");
        }

        pageHandle(queryVo);

        Map<String, Object> map = new HashMap<>(16);
        map.put("userId", queryVo.getUserId());
        int total = payRecordMapper.count(map);

        map.put("startNum", queryVo.getStartNum());
        map.put("endNum", queryVo.getEndNum());
        List<PayRecordShowVo> list = payRecordMapper.getList(map);


        PageInfo<PayRecordShowVo> info = new PageInfo<>();
        info.setPageSize(queryVo.getPageSize());
        info.setPageNum(queryVo.getPageNo());
        info.setTotal(total);
        info.setList(list);
        return R.ok(info);
    }

    @Override
    public R<Boolean> add(PayRecord payRecord) {
        log.info("volunteer-service[]PayRecordServiceImpl[]payRecord[]input.param.payRecord:" + payRecord);
        if (null == payRecord) {
            return R.ok(1, false);
        }

        //保存充值记录信息
        int count = payRecordMapper.add(payRecord);
        if (count == 0) {
            return R.ok(1, false);
        }

        return R.ok(0, true);
    }

    /**
     * 分页处理方法
     *
     * @param orderQueryVo 参数
     */
    private void pageHandle(PayRecordQueryVo orderQueryVo) {
        Integer pageNum = orderQueryVo.getPageNo();
        Integer pageSize = orderQueryVo.getPageSize();
        if (null == pageSize || pageSize == 0) {
            pageSize = 10;
        }
        if (null == pageNum || pageNum == 0) {
            pageNum = 1;
        }
        Integer endNum = pageSize;
        Integer startNum = (pageNum - CommonAttributes.NUM_ONE) * pageSize;
        orderQueryVo.setEndNum(endNum);
        orderQueryVo.setStartNum(startNum);
        orderQueryVo.setPageNo(pageNum);
        orderQueryVo.setPageSize(pageSize);
    }
}
