package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.*;
import cn.wisenergy.mapper.CardMapper;
import cn.wisenergy.mapper.RefillCardMapper;
import cn.wisenergy.model.app.CardInfo;
import cn.wisenergy.model.app.RefillCard;
import cn.wisenergy.model.dto.ExportCardDto;
import cn.wisenergy.model.dto.RefillCardDto;
import cn.wisenergy.service.app.RefillCardService;
import cn.wisenergy.service.common.RefillCardManager;
import com.alibaba.excel.EasyExcel;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class RefillCardServiceImpl implements RefillCardService {
    @Autowired
    RefillCardMapper refillCardMapper;

    @Autowired
    private CardMapper cardMapper;

    @Autowired
    private RefillCardManager refillCardManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public R<Boolean> add(RefillCard refillCard) {
        log.info("RefillCardServiceImpl[].add[].input.param:refillCard:{}"+refillCard);

        if (refillCard.getCardNumber()==0||null==refillCard.getCardNumber()) {
            return R.error("输入的卡数无效是无效值");
        }
        //设置初始状态
        String time = DateUtil.getTime(new Date(), "yyyy.MM.dd.HH.mm.sss");
        refillCard.setBatchNumber(time);
        refillCard.setIsActivite(1);
        refillCard.setIsMakeCard(1);
        refillCard.setIsDelete(0);
        int add = refillCardMapper.add(refillCard);

        //判断数据是否添加成功
        if (add==0) {
            return R.error("数据添加失败");
        }
        return R.ok(0,true);
    }

    @Override
    public R<Boolean> update(String batchNumber) {
        log.info("RefillCardServiceImpl[].update[].input.param:batchNumber:"+batchNumber);
        if (StringUtils.isEmpty(batchNumber)) {
            return R.error("传入参数为空");
        }
        int update = refillCardMapper.update(batchNumber);
        if (update==0) {
            R.ok(1,false);
        }
        return R.ok(0,true);
    }

    @Override
    public R<PageInfo<RefillCardDto>> getList(Integer pageNum, Integer pageSize) {
        log.info("RefillCardServiceImpl[].getList[].input.param:pageNum,pageSize"+pageNum+ pageSize);
        if (null == pageSize || pageSize == 0) {
            pageSize = 10;
        }
        if (null == pageNum || pageNum == 0) {
            pageNum = 1;
        }

        //创建参数容器
        HashMap<String, Object> map = new HashMap<>(4);
        map.put("pageNo",(pageNum-1)*pageSize);
        map.put("pageSize",pageSize);
        ArrayList<RefillCardDto> refillCardDtos = new ArrayList<>();

        //查询参数
        List<RefillCard> list = refillCardMapper.getList(map);
        for (RefillCard refillCard : list) {
            RefillCardDto refillCardDto = new RefillCardDto();
            BeanUtils.copyProperties(refillCard,refillCardDto);
            refillCardDtos.add(refillCardDto);
        }

        PageInfo<RefillCardDto> refillCardDtoPageInfo = new PageInfo<>();
        refillCardDtoPageInfo.setTotal(refillCardMapper.getUserNumbers());
        refillCardDtoPageInfo.setPageNum(pageNum);
        refillCardDtoPageInfo.setPageSize(pageSize);
        refillCardDtoPageInfo.setList(refillCardDtos);
        return R.ok(refillCardDtoPageInfo);
    }

    @Override
    public R<Boolean> createCard(Integer id) {
        log.info("RefillCardServiceImpl[].createCard[].input.param:id"+id);
        if (null==id||id==0) {
            return R.error("传入参数为空");
        }

        //查询充值卡信息
        RefillCard byId = refillCardMapper.getById(id);
        if (null==byId) {
            return R.error("该充值卡不存在");
        }

        return refillCardManager.addCardMannger(byId);
    }

    @Override
    public R<Boolean> createExcel(String batchNumber, HttpServletResponse response) {
        log.info("RefillCardServiceImpl[].createExcel[].input.param:batchNumber"+batchNumber);

        if (StringUtils.isEmpty(batchNumber)) {
            return R.error("传入的参数为空");
        }

        try {
            //  设置内容格式 以及 编码方式
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");

            //   调用service去获取数据
            List<CardInfo> list = cardMapper.getList(batchNumber);
            if (CollectionUtils.isEmpty(list)) {
                return R.error("该批次号暂时未有子卡");
            }

            //  使用java8新特性的stream流去处理数据，把空的数据过滤掉
            List<ExportCardDto> resultBo = list.stream().filter(Objects::nonNull)
                    .map(t -> {
                        return ExportCardDto.builder()
                                .cardNumber(t.getCardNumber())
                                .secretKey(t.getSecretKey())
                                .status(t.getStatus()==0?"未使用":"已使用")
                                .build();
                    }).collect(Collectors.toList());

            //  设置文件名称
            String fileName = batchNumber;

            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");

            //  sheet名称
            EasyExcel.write(response.getOutputStream(), ExportCardDto.class).sheet(batchNumber).doWrite(resultBo);
            return R.ok(0,true);
        } catch (Exception e) {
            return R.ok(1,false);
        }
    }

}
