package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.enums.SceneType;
import cn.wisenergy.model.enums.SourceType;
import cn.wisenergy.model.vo.SendSmsVo;
import cn.wisenergy.service.app.SendSmsSerVice;
import cn.wisenergy.service.cache.RedisService;
import cn.wisenergy.service.common.CachePrefix;
import cn.wisenergy.service.common.Common;
import com.alibaba.fastjson.JSON;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 86187
 * @ Description: 短信验证码接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/15 15:45
 */
@Service
@Slf4j
public class SendSmsSerViceImpl implements SendSmsSerVice {

    @Autowired
    private RedisService redisService;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private UsersMapper usersMapper;

    private static final String SMS_RESULT = "OK";

    @Override
    public R<Boolean> sendSmCode(SendSmsVo sendSmsVo) throws Exception {
        log.info("volunteer-service[]SendSmsSerViceImpl[]sendSmCode[]input.param.sendSmsVo:" + sendSmsVo);
        if (null == sendSmsVo || StringUtils.isBlank(sendSmsVo.getPhone()) ||
                null == sendSmsVo.getSource() || null == sendSmsVo.getScene()) {
            return R.error("入参不能为空!");
        }

        DefaultProfile profile = DefaultProfile.getProfile("cn-hangzhou", Common.ACCESS_KEY_ID, Common.SMS_SECRET);
        IAcsClient client = new DefaultAcsClient(profile);

        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");

        //生成六位随机数作为短信验证码
        int code = (int) ((Math.random() * 9 + 1) * 100000);

        //保存验证到缓存，以便做验证
        String source = SourceType.getByCode(sendSmsVo.getSource());
        String scene = SceneType.getNameByCode(sendSmsVo.getScene());
     /*   boolean bool = redisService.set(CachePrefix.SMS_CODE.getPrefix() + scene + "_" +
                source + "_" + sendSmsVo.getPhone(), code, Common.SMS_TIMEOUT);*/
        boolean bool = redisService.set(CachePrefix.SMS_CODE.getPrefix()  + "_" +
                source + "_" + sendSmsVo.getPhone(), code, Common.SMS_TIMEOUT);
        log.info(CachePrefix.SMS_CODE.getPrefix());
        if (!bool) {
            return R.error("缓存验证码失败!");
        }
        Map<String, Object> map = new HashMap<>(4);
        map.put("code", code);
        request.putQueryParameter("RegionId", "cn-hangzhou");
        request.putQueryParameter("PhoneNumbers", sendSmsVo.getPhone());
        request.putQueryParameter("SignName", "山东宇嘉雪教育");
        if (sendSmsVo.getScene()==1) {
            request.putQueryParameter("TemplateCode", "SMS_211755494");
        }

        if (sendSmsVo.getScene()==2) {
            request.putQueryParameter("TemplateCode", "SMS_211755492");
        }

        if (sendSmsVo.getScene()==5) {
            request.putQueryParameter("TemplateCode", "SMS_211755491");
        }

        if (sendSmsVo.getScene()==4) {
            request.putQueryParameter("TemplateCode", "SMS_211755495");
        }
        request.putQueryParameter("TemplateParam", JSON.toJSONString(map));
        try {
            //发送验证码
            CommonResponse response = client.getCommonResponse(request);
            log.info("输出短信返回参数:" + response);
        } catch (ClientException e) {
            return R.error("验证码发送失败");
        }

        return R.ok(0, true);
    }

    @Override
    public R<Boolean> valid(String phone, String code, Integer type, String source) {
        String value = SceneType.getNameByCode(type);
        //获取短信验证码key
        //String key = CachePrefix.SMS_CODE.getPrefix() + value + "_" + source + "_" + phone;
        String key = CachePrefix.SMS_CODE.getPrefix() + "_" + source + "_" + phone;
        //判断缓存是否过期
        long time = redisService.getExpire(key);
        if (time < 0) {
            return R.error(1, "验证码已过期!", false);
            //return R.ok(0, true);
        }

        //redis中获取验证码
        Object obj = redisService.get(key);
        if (obj != null) {
            String smCode = obj.toString();
            if (code.equals(smCode)) {
                //验证码存在，校验通过，清除验证码缓存
                redisService.del(key);
                return R.ok(0, true);
            } else {
                return R.error(1, "验证码错误!", false);
                //return R.ok(0, true);
            }
        }
        return R.ok(1, false);
        //return R.ok(0, true);
    }
}
