package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.*;
import cn.wisenergy.model.app.*;
import cn.wisenergy.model.enums.CardStatus;
import cn.wisenergy.model.enums.PayType;
import cn.wisenergy.model.vo.AddLimitVo;
import cn.wisenergy.service.app.UserLimitService;
import cn.wisenergy.service.common.VolunteerManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author 86187
 */
@Service
@Slf4j
public class UserLimitServiceImpl extends ServiceImpl<UserLimitMapper, UserLimit> implements UserLimitService {

    @Autowired
    private PriceMapper priceMapper;

    @Autowired
    private UserLimitMapper userLimitMapper;

    @Autowired
    private PayRecordMapper payRecordMapper;

    @Autowired
    private CardMapper cardMapper;

    @Autowired
    private UserLimitRecordMapper userLimitRecordMapper;

    @Autowired
    private VolunteerManager volunteerManager;

    @Autowired
    private RefillCardMapper refillCardMapper;

    @Override
    public R<UserLimit> getByUserId(Integer userId) {
        log.info("volunteer-service[]UserLimitServiceImpl[]getByUserId[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参不能为空!");
        }

        //由用户id,获取用户查询次数信息
        QueryWrapper<UserLimit> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userId);
        UserLimit userLimit = baseMapper.selectOne(queryWrapper);

        return R.ok(userLimit);
    }

    @Override
    public R<Boolean> addLimit(AddLimitVo addLimitVo) {
        log.info("volunteer-service[]UserLimitServiceImpl[]addLimit[]input.param.addLimitVo:" + addLimitVo);
        if (null == addLimitVo || null == addLimitVo.getUserId() || null == addLimitVo.getPayType()) {
            return R.error("入参不能为空!");
        }

        Integer userId = addLimitVo.getUserId();
        //判断用户查询次数信息是否存在
        UserLimit userLimit = userLimitMapper.getByUserId(userId);
        if (null == userLimit) {
            return R.error("用户查询信息不存在!");
    }

        //1、充值卡
        if (PayType.REFILL_CARD.getCode().equals(addLimitVo.getPayType())) {
            if (StringUtils.isBlank(addLimitVo.getPassword())) {
                return R.error(1,"充值卡密码不能为空!",false);
            }

            //根据密码获取充值卡信息
            CardInfo cardInfo = cardMapper.getBySecretKey(addLimitVo.getPassword());
            if (null == cardInfo || StringUtils.isBlank(cardInfo.getBatchNumber())) {
                return R.error(1,"充值卡信息不存在!",false);
            }

            if (cardInfo.getStatus().equals(CardStatus.ALREADY_USED.getCode())) {
                return R.error(1,"充值卡已使用，请购买新卡!",false);
            }

            //获取主卡信息
            RefillCard refillCard = refillCardMapper.getByBatchNumber(cardInfo.getBatchNumber());
            if (null == refillCard) {
                return R.error(1,"充值卡信息不存在!",false);
            }

            if (refillCard.getIsActivite() == 1) {
                return R.error(1,"充值卡未激活，请联系管理员激活!",false);
            }

            //增加用户可用查询次数
            Integer usableNumber = userLimit.getUsableLimit() + cardInfo.getLimit();

            //增加用户总查询次数
            Integer total = userLimit.getTotalLimit() + cardInfo.getLimit();
            userLimit.setUsableLimit(usableNumber);
            userLimit.setTotalLimit(total);

            //更新充值卡状态和用户查询次数及增加充值记录
            boolean bool = volunteerManager.updateLimitAndRecord(new Price(), cardInfo, userLimit, addLimitVo);
            return R.ok(bool);

        } else {
            //2、微信或者支付宝
            if (null == addLimitVo.getPayMoney()) {
                return R.error(1,"支付金额不能为空!",false);
            }

            //根据支付的金额，查询用户新增查询次数
            Price price = priceMapper.getByMoney(addLimitVo.getPayMoney());

            //增加用户可用查询次数
            Integer usableNumber = userLimit.getUsableLimit() + price.getUseLimit();

            //增加用户总查询次数
            Integer total = userLimit.getTotalLimit() + price.getUseLimit();
            userLimit.setUsableLimit(usableNumber);
            userLimit.setTotalLimit(total);

            //更新充值卡状态和用户查询次数及增加充值记录
            boolean bool = volunteerManager.updateLimitAndRecord(price, new CardInfo(), userLimit, addLimitVo);
            return R.ok(bool);
        }
    }

    @Override
    public R<Boolean> minusLimit(Integer userId) {
        log.info("volunteer-service[]UserLimitServiceImpl[]minusLimit[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参不能为空!");
        }

        //获取用户查询次数信息
        UserLimit userLimit = userLimitMapper.getByUserId(userId);
        if (null == userLimit) {
            return R.error("用户查询信息不存在!");
        }

        if (userLimit.getUsableLimit() == 0) {
            return R.error(1, "您的查询次数已使用完了，请充值!", false);
        }

        //扣减用户可用查询次数
        int usableLimit = userLimit.getUsableLimit() - 1;

        //增加用户已使次数
        int useLimit = userLimit.getUseLimit() + 1;
        userLimit.setUsableLimit(usableLimit);
        userLimit.setUseLimit(useLimit);

        //更新用户查询信息并保存扣减记录
        boolean bool = volunteerManager.updateLimitSaveRecord(userLimit);
        if (bool) {
            return R.ok(0, true);
        }
        return R.ok(1, false);
    }
}
