package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.dto.PayPageDto;
import cn.wisenergy.model.dto.PayQueryDto;
import cn.wisenergy.model.vo.AddLimitVo;
import cn.wisenergy.service.app.UserLimitService;
import cn.wisenergy.service.app.WxPayService1;

import cn.wisenergy.service.httpClient.WechatPayHttpClientBuilder;
import cn.wisenergy.service.httpClient.auth.AutoUpdateCertificatesVerifier;
import cn.wisenergy.service.httpClient.auth.PrivateKeySigner;
import cn.wisenergy.service.httpClient.auth.WechatPay2Credentials;
import cn.wisenergy.service.httpClient.auth.WechatPay2Validator;
import cn.wisenergy.service.httpClient.util.PemUtil;
import cn.wisenergy.service.util.SignDemo;
import cn.wisenergy.service.wxpay.WxCommon;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import okhttp3.HttpUrl;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import javax.crypto.IllegalBlockSizeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;

import java.util.UUID;


/**
 * @author 86187
 */
@Service
@Slf4j
public class WxPayService1Impl implements WxPayService1 {

    @Autowired
    private UserLimitService userLimitService;
    /**
     * 商户号
     */
    private static String mchId = WxCommon.MCHID;
    // 商户证书序列号
    private static String mchSerialNo = WxCommon.SERIAL_NO;
    // api密钥
    private static String apiV3Key = WxCommon.SECRET_KEY;
    // 你的商户私钥
    private static String privateKey = "-----BEGIN PRIVATE KEY-----\n" + WxCommon.PRIVATE_KEY
            + "-----END PRIVATE KEY-----\n";

    private CloseableHttpClient httpClient;
    private AutoUpdateCertificatesVerifier verifier;

    @Before
    public void setup() throws IOException {
        PrivateKey merchantPrivateKey = PemUtil.loadPrivateKey(
                new ByteArrayInputStream(privateKey.getBytes("utf-8")));

        //使用自动更新的签名验证器，不需要传入证书
        verifier = new AutoUpdateCertificatesVerifier(
                new WechatPay2Credentials(mchId, new PrivateKeySigner(mchSerialNo, merchantPrivateKey)),
                apiV3Key.getBytes("utf-8"));

        httpClient = WechatPayHttpClientBuilder.create()
                .withMerchant(mchId, mchSerialNo, merchantPrivateKey)
                .withValidator(new WechatPay2Validator(verifier))
                .build();
    }

    @After
    public void after() throws IOException {
        httpClient.close();
    }


    @Override
    public R<String> wxPay(PayPageDto payPageDto) {
        if (null == payPageDto || null == payPageDto.getTotal()) {
            return R.error("入参不能为空!");
        }

        HttpPost httpPost = new HttpPost();
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.addHeader("Accept", "application/json");

        long timestamp = System.currentTimeMillis() / 1000;
        String nonceStr = UUID.randomUUID().toString().replace("-", "");
        String method = "POST";
        String tradeNo = "21" + System.currentTimeMillis();
        HttpUrl httpurl = HttpUrl.parse(WxCommon.WX_PAY_URL_pc);

        //构造签名参数
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", WxCommon.APP_ID);
        jsonObject.put("mchid", WxCommon.MCHID);
        jsonObject.put("description", "充值");
        jsonObject.put("out_trade_no", tradeNo);
        jsonObject.put("notify_url", WxCommon.NOTIFY_URL);
        jsonObject.put("amount", payPageDto.getTotal());
        String sign = null;
        try {
            sign = SignDemo.getToken(method, httpurl, jsonObject.toJSONString(), nonceStr, timestamp);
            httpPost.setHeader("Authorization", "WECHATPAY2-SHA256-RSA2048" + " " + sign);

            //增加用户查询次数和充值记录
            AddLimitVo addLimitVo = new AddLimitVo();
            addLimitVo.setPayMoney(payPageDto.getTotal());
            addLimitVo.setPayType(2);
            addLimitVo.setUserId(payPageDto.getUserId());
            R<Boolean> booleanR = userLimitService.addLimit(addLimitVo);
            if (booleanR.getCode()==1) {
                return R.error("用户查询次数添加失败");
            }
            return R.ok(0,"充值成功");
        } catch (Exception e) {
            return R.ok(1,"充值失败");
        }
    }

    @Override
    public R<String> queryWx(PayQueryDto payQueryDto) throws UnsupportedEncodingException, NoSuchAlgorithmException, SignatureException, InvalidKeySpecException, InvalidKeyException {
        if (null == payQueryDto || StringUtils.isBlank(payQueryDto.getOutTradeNo())) {
            return R.error("入参不能为空!");
        }

        long timestamp = System.currentTimeMillis() / 1000;
        String nonceStr = UUID.randomUUID().toString().replace("-", "");
        String method = "GET";
        String url = WxCommon.WX_PAY_QUERY + payQueryDto.getOutTradeNo() + "?mchid=" + WxCommon.MCHID;
        HttpUrl httpurl = HttpUrl.parse(url);

        //构造签名参数
        String sign = SignDemo.getToken(method, httpurl, null, nonceStr, timestamp);
        HttpGet httpGet = new HttpGet();
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.addHeader("Accept", "application/json");
        //设置认证信息
        httpGet.setHeader("Authorization", "WECHATPAY2-SHA256-RSA2048" + " " + sign);

        return null;
    }

    @Override
    public R<String> wx_Pay(PayPageDto payPageDto) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeySpecException, InvalidKeyException, IllegalBlockSizeException {
        HttpPost httpPost = new HttpPost(WxCommon.WX_PAY_URL_pc);

        long timestamp = System.currentTimeMillis() / 1000;
        String nonceStr = UUID.randomUUID().toString().replace("-", "");
        String method = "POST";
        String tradeNo = "21" + System.currentTimeMillis();
        HttpUrl httpurl = HttpUrl.parse(WxCommon.WX_PAY_URL_pc);

        // 请求body参数
        String reqdata = "{"
                + "\"time_expire\":\"2021-02-07T10:34:56+08:00\","
                + "\"amount\": {"
                + "\"total\":" + payPageDto.getTotal() + ","
                + "\"currency\":\"CNY\""
                + "},"
                + "\"mchid\":\"" + WxCommon.MCHID + "\","
                + "\"description\":\"Image形象店-深圳腾大-QQ公仔\","
                + "\"notify_url\":\"" + WxCommon.NOTIFY_URL + "\","
                + "\"out_trade_no\":\"" + tradeNo + "\","
                + "\"goods_tag\":\"WXG\","
                + "\"appid\":\"" + WxCommon.APP_ID + "\","
                + "\"attach\":\"自定义数据说明\","
                + "\"detail\": {"
                + "\"invoice_id\":\"wx123\","
                + "\"goods_detail\": ["
                + "{"
                + "\"goods_name\":\"iPhoneX 256G\","
                + "\"wechatpay_goods_id\":\"1001\","
                + "\"quantity\":1,"
                + "\"merchant_goods_id\":\"商品编码\","
                + "\"unit_price\":828800"
                + "},"
                + "{"
                + "\"goods_name\":\"iPhoneX 256G\","
                + "\"wechatpay_goods_id\":\"1001\","
                + "\"quantity\":1,"
                + "\"merchant_goods_id\":\"商品编码\","
                + "\"unit_price\":828800"
                + "}"
                + "],"
                + "\"cost_price\":608800"
                + "},"
                + "\"scene_info\": {"
                + "\"store_info\": {"
                + "\"address\":\"广东省深圳市南山区科技中一道10000号\","
                + "\"area_code\":\"440305\","
                + "\"name\":\"腾讯大厦分店\","
                + "\"id\":\"0001\""
                + "},"
                + "\"device_id\":\"013467007045764\","
                + "\"payer_client_ip\":\"14.23.150.211\""
                + "}"
                + "}";
        StringEntity reqEntity = new StringEntity(
                reqdata, ContentType.create("application/json", "utf-8"));
        httpPost.setEntity(reqEntity);
        httpPost.addHeader("Accept", "application/json");

        //构造签名参数
        //构造签名参数
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("appid", WxCommon.APP_ID);
        jsonObject.put("mchid", WxCommon.MCHID);
        jsonObject.put("description", "充值");
        jsonObject.put("out_trade_no", tradeNo);
        jsonObject.put("notify_url", WxCommon.NOTIFY_URL);
        jsonObject.put("amount", payPageDto);
        String token = SignDemo.getToken(method, httpurl, jsonObject.toJSONString(), nonceStr, timestamp);
        httpPost.setHeader("Authorization", "WECHATPAY2-SHA256-RSA2048" + " " + token);

        //1.创建HttpClient对象
        CloseableHttpClient httpClient = HttpClients.createDefault();
        //完成签名并执行请求
        CloseableHttpResponse response = httpClient.execute(httpPost);


        try {
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                String content = EntityUtils.toString(httpEntity, "utf8");
                System.out.println(content.length());
                return R.ok(response.toString());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }finally {
            response.close();
        }
        return null;
    }
}
