package cn.wisenergy.service.common;

import cn.wisenergy.model.app.Volunteer;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;

import java.io.Serializable;
import java.util.List;

/**
 * 创建PDF工具类
 */
public class PdfUtil implements Serializable {
    private static final long serialVersionUID = -8441049720133017215L;
    // 定义全局的字体静态变量
    private static Font titlefont;
    private static Font headfont;
    private static Font keyfont;
    private static Font textfont;

    //序号
    private  Integer id=0;

    // 最大宽度
    private static int maxWidth = 520;

    // 静态代码块
    static {
        try {
            // 不同字体（这里定义为同一种字体：包含不同字号、不同style）
            BaseFont bfChinese = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.NOT_EMBEDDED);
            titlefont = new Font(bfChinese, 16, Font.BOLD);
            headfont = new Font(bfChinese, 14, Font.BOLD);
            keyfont = new Font(bfChinese, 10, Font.BOLD);
            textfont = new Font(bfChinese, 10, Font.NORMAL);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    // 生成PDF文件
    public  void  generatePDF(Document document, List<Volunteer> list,String name, String queryRecordTime) throws Exception {


        // 表格
        PdfPTable table = createTable(new float[] { 40,80,80, 80, 80, 80, 80, 80, 40, 40, 40 });
        table.addCell(createCell("查询时间："+queryRecordTime+"     "+"用户名："+name,headfont,Element.ALIGN_LEFT, 11, false));
        table.addCell(createCell("序号", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("专业", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("院校", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("选考科目要求", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("学校性质", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("学制（年）", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("计划数", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("投档计划数", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("投出数", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("参考分", keyfont, Element.ALIGN_CENTER));
        table.addCell(createCell("最低位次", keyfont, Element.ALIGN_CENTER));
        for (Volunteer volunteer : list)
            {
            table.addCell(createCell((++id).toString() , textfont));
            table.addCell(createCell(volunteer.getMajorName(), textfont));
            table.addCell(createCell(volunteer.getAcademy(), textfont));
            table.addCell(createCell(volunteer.getCourseDemand(), textfont));
            table.addCell(createCell(volunteer.getNature(), textfont));
            table.addCell(createCell(volunteer.getYearLimit().toString(), textfont));
            table.addCell(createCell(volunteer.getPlanNum().toString(), textfont));
            table.addCell(createCell(null==volunteer.getCastArchivesNum()?"":volunteer.getCastArchivesNum().toString(), textfont));
            table.addCell(createCell(null==volunteer.getLaunchNum()?"":volunteer.getLaunchNum().toString(), textfont));
            table.addCell(createCell(null==volunteer.getLowestMark()?"":volunteer.getLowestMark().toString(), textfont));
            table.addCell(createCell(null==volunteer.getLowestRank()?"":volunteer.getLowestRank(), textfont));
        }
        document.add(table);
    }


/**------------------------创建表格单元格的方法start----------------------------*/
    /**
     * 创建单元格(指定字体)
     * @param value
     * @param font
     * @return
     */
    public PdfPCell createCell(String value, Font font) {
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell.setPhrase(new Phrase(value, font));
        return cell;
    }
    /**
     * 创建单元格（指定字体、水平..）
     * @param value
     * @param font
     * @param align
     * @return
     */
    public PdfPCell createCell(String value, Font font, int align) {
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(align);
        cell.setPhrase(new Phrase(value, font));
        return cell;
    }
    /**
     * 创建单元格（指定字体、水平居..、单元格跨x列合并）
     * @param value
     * @param font
     * @param align
     * @param colspan
     * @return
     */
    public PdfPCell createCell(String value, Font font, int align, int colspan) {
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(align);
        cell.setColspan(colspan);
        cell.setPhrase(new Phrase(value, font));
        return cell;
    }
    /**
     * 创建单元格（指定字体、水平居..、单元格跨x列合并、设置单元格内边距）
     * @param value
     * @param font
     * @param align
     * @param colspan
     * @param boderFlag
     * @return
     */
    public PdfPCell createCell(String value, Font font, int align, int colspan, boolean boderFlag) {
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(align);
        cell.setColspan(colspan);
        cell.setPhrase(new Phrase(value, font));
        cell.setPadding(3.0f);
        if (!boderFlag) {
            cell.setBorder(0);
            cell.setPaddingTop(15.0f);
            cell.setPaddingBottom(8.0f);
        } else if (boderFlag) {
            cell.setBorder(0);
            cell.setPaddingTop(0.0f);
            cell.setPaddingBottom(15.0f);
        }
        return cell;
    }
    /**
     * 创建单元格（指定字体、水平..、边框宽度：0表示无边框、内边距）
     * @param value
     * @param font
     * @param align
     * @param borderWidth
     * @param paddingSize
     * @param flag
     * @return
     */
    public PdfPCell createCell(String value, Font font, int align, float[] borderWidth, float[] paddingSize, boolean flag) {
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(align);
        cell.setPhrase(new Phrase(value, font));
        cell.setBorderWidthLeft(borderWidth[0]);
        cell.setBorderWidthRight(borderWidth[1]);
        cell.setBorderWidthTop(borderWidth[2]);
        cell.setBorderWidthBottom(borderWidth[3]);
        cell.setPaddingTop(paddingSize[0]);
        cell.setPaddingBottom(paddingSize[1]);
        if (flag) {
            cell.setColspan(2);
        }
        return cell;
    }
/**------------------------创建表格单元格的方法end----------------------------*/


/**--------------------------创建表格的方法start------------------- ---------*/
    /**
     * 创建默认列宽，指定列数、水平(居中、右、左)的表格
     * @param colNumber
     * @param align
     * @return
     */
    public PdfPTable createTable(int colNumber, int align) {
        PdfPTable table = new PdfPTable(colNumber);
        try {
            table.setTotalWidth(maxWidth);
            table.setLockedWidth(true);
            table.setHorizontalAlignment(align);
            table.getDefaultCell().setBorder(1);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return table;
    }
    /**
     * 创建指定列宽、列数的表格
     * @param widths
     * @return
     */
    public PdfPTable createTable(float[] widths) {
        PdfPTable table = new PdfPTable(widths);
        try {
            table.setTotalWidth(maxWidth);
            table.setLockedWidth(true);
            table.setHorizontalAlignment(Element.ALIGN_CENTER);
            table.getDefaultCell().setBorder(1);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return table;
    }
    /**
     * 创建空白的表格
     * @return
     */
    public PdfPTable createBlankTable() {
        PdfPTable table = new PdfPTable(1);
        table.getDefaultCell().setBorder(0);
        table.addCell(createCell("", keyfont));
        table.setSpacingAfter(20.0f);
        table.setSpacingBefore(20.0f);
        return table;
    }

}
