package cn.wisenergy.service.common;

import cn.wisenergy.common.utils.CardNumberUtil;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.common.utils.SecretkeyUtil;
import cn.wisenergy.mapper.CardMapper;
import cn.wisenergy.mapper.RefillCardMapper;
import cn.wisenergy.model.app.CardInfo;
import cn.wisenergy.model.app.RefillCard;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;

/**
 * @author 86187
 */
@Component
@Slf4j
public class RefillCardManager {

    @Autowired
    private RefillCardMapper refillCardMapper;

    @Autowired
    private CardMapper cardMapper;

    @Transactional(rollbackFor = Exception.class)
    public  R<Boolean> addCardMannger(RefillCard byId){
        //获取充值卡的卡数，并生成卡片
        ArrayList<CardInfo> cardInfos = new ArrayList<>();

        //子卡添加
        for (int i = 0; i < byId.getCardNumber(); i++) {
            CardInfo cardInfo = new CardInfo();
            cardInfo.setBatchNumber(byId.getBatchNumber());
            cardInfo.setIsDelete(0);
            cardInfo.setMoney("498");
            cardInfo.setStatus(0);
            cardInfo.setLimit(3);
            cardInfo.setSecretKey(SecretkeyUtil.getSecretkey());
            cardInfo.setCardNumber(CardNumberUtil.cardNumber());
            cardInfos.add(cardInfo);
        }
        int add1 = cardMapper.add(cardInfos);

        if (add1==0) {
            return R.ok(1,false);
        }
        int isMakeCard = refillCardMapper.setIsMakeCard(byId.getId());

        if (isMakeCard==0) {
            return R.ok(1,false);
        }
        return R.ok(0,true);

    }
}
