package cn.wisenergy.service.util;

import cn.wisenergy.model.dto.PayPageDto;
import cn.wisenergy.service.wxpay.WxCommon;
import com.alibaba.fastjson.JSONObject;
import okhttp3.HttpUrl;

import java.io.UnsupportedEncodingException;
import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.UUID;

/**
 * @author 86187
 */
public class SignDemo {

    public static String getToken(String method, HttpUrl url, String body,String nonceStr,long timestamp) throws UnsupportedEncodingException, SignatureException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        String message = buildMessage(method, url, timestamp, nonceStr, body);
        String signature = sign(message.getBytes("utf-8"));

        return "mchid=\"" + WxCommon.MCHID + "\","
                + "nonce_str=\"" + nonceStr + "\","
                + "timestamp=\"" + timestamp + "\","
                + "serial_no=\"" + WxCommon.SERIAL_NO + "\","
                + "signature=\"" + signature + "\"";
    }

    public static String sign(byte[] message) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, InvalidKeySpecException {
        Signature sign = Signature.getInstance("SHA256withRSA");
        KeyFactory factory = KeyFactory.getInstance("RSA");


        PrivateKey privateKey = factory.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(WxCommon.SECRET_KEY)));
        sign.initSign(privateKey);
        sign.update(message);

        return Base64.getEncoder().encodeToString(sign.sign());
    }

    public static String buildMessage(String method, HttpUrl url, long timestamp, String nonceStr, String body) {
        String canonicalUrl = url.encodedPath();
        if (url.encodedQuery() != null) {
            canonicalUrl += "?" + url.encodedQuery();
        }

        return method + "\n"
                + canonicalUrl + "\n"
                + timestamp + "\n"
                + nonceStr + "\n"
                + body + "\n";
    }

//    public static void main(String[] args) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, UnsupportedEncodingException, InvalidKeySpecException {
//        String method = "POST";
//        HttpUrl httpurl = HttpUrl.parse("https://api.mch.weixin.qq.com/v3/pay/transactions/jsapi");
//        long timestamp = System.currentTimeMillis() / 1000;
//        String nonceStr = UUID.randomUUID().toString().replace("-", "");
//        String url = "v3/pay/transactions/native";
//        String tradeNo = "21" + System.currentTimeMillis();
//        PayPageDto payPageDto = new PayPageDto();
//        payPageDto.setTotal(100);
//
//        //构造签名body
//        JSONObject jsonObject = new JSONObject();
//        jsonObject.put("appid", WxCommon.APP_ID);
//        jsonObject.put("mchid", WxCommon.MCHID);
//        jsonObject.put("timestamp", timestamp);
//        jsonObject.put("nonce_str", nonceStr);
//        jsonObject.put("url", url);
//        jsonObject.put("method", method);
//        jsonObject.put("description", "充值");
//        jsonObject.put("out_trade_no", tradeNo);
//        jsonObject.put("notify_url", WxCommon.NOTIFY_URL);
//        jsonObject.put("amount", payPageDto);
//        String sign = getToken(method, httpurl, jsonObject.toJSONString());
//        System.out.println("签名：" + sign);
//    }
}
