package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.dto.PayPageDto;
import cn.wisenergy.model.dto.PayQueryDto;
import cn.wisenergy.service.app.AliPayService;
import cn.wisenergy.service.app.TestWxPayService;
import cn.wisenergy.service.app.WxPayService1;
import cn.wisenergy.service.common.Common;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.crypto.IllegalBlockSizeException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.SortedMap;

/**
 * @author 86187
 * @ Description:
 * @ Author     : 86187
 * @ Date       : 2021/2/1 10:05
 */
@RestController
@Api(tags = "PC-支付接口")
@RequestMapping("/pay")
@Slf4j
public class PayController {

    @Autowired
    private TestWxPayService testWxPayService;

    @Autowired
    private AliPayService aliPayService;


    @ApiOperation(value = "PC支付宝-支付接口", notes = "PC支付宝-支付接口", httpMethod = "POST")
    @ApiImplicitParam(name = "payPageDto", value = "参数", dataType = "PayPageDto")
    @PostMapping("/page")
    public R<String> doPost(@RequestBody PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse httpResponse) {
   /* public R<String> doPost(Integer userId,Integer payType,Integer total_amount, HttpServletRequest request, HttpServletResponse httpResponse) {
        PayPageDto payPageDto = new PayPageDto();
        payPageDto.setTotal(total_amount);
        payPageDto.setUserId(userId);
        payPageDto.setPayType(payType);*/
        return aliPayService.doPost(payPageDto,request,httpResponse);
    }
    @ApiOperation(value = "手机网页支付宝-支付接口", notes = "手机网页支付宝-支付接口", httpMethod = "POST")
    @ApiImplicitParam(name = "payPageDto", value = "参数", dataType = "PayPageDto")
    @PostMapping("/wapAliPay")
    public R<String> wapAliPay(@RequestBody PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse httpResponse) {
        return aliPayService.wapAliPay(payPageDto,request,httpResponse);
    }

    @ApiOperation(value = "PC支付宝-交易查询", notes = "PC支付宝-交易查询", httpMethod = "POST")
    @ApiImplicitParam(name = "payQueryDto", value = "查询参数", dataType = "PayQueryDto")
    @PostMapping("/query")
    public R<String> query(@RequestBody PayQueryDto payQueryDto) throws AlipayApiException {
        AlipayClient alipayClient = new DefaultAlipayClient(Common.PAY_URL_CS, Common.APP_ID_CS, Common.PRIVATE_KEY_CS, "json", "GBK", Common.ALIPAY_PUBLIC_KEY_CS, "RSA2");
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        request.setBizContent("{" +
                "    \"out_trade_no\":\"" + payQueryDto.getOutTradeNo() + "\"," +
                "    \"trade_no\":\"" + payQueryDto.getTradeNo() + "\"" +
                "  }");
        AlipayTradeQueryResponse response = alipayClient.execute(request);
        System.out.println(response.getBody());
        return R.ok(response.getBody());
    }

    /**
     * 支付宝回调函数
     * 支付成功后服务器会调用此方法
     */
    @ApiOperation(value = "支付回调", notes = "支付回调", httpMethod = "POST")
    @RequestMapping(value = "/aliPayCallBack.do")
    public void aliPayCallBack(HttpServletResponse response, HttpServletRequest request) throws Exception {
        aliPayService.aliPayCallBack(response, request);
    }


    @ApiOperation(value = "微行支付-统一下单", notes = "微行支付-统一下单", httpMethod = "POST")
    @ApiImplicitParam(name = "payPageDto", value = "支付入参", dataType = "PayPageDto")
    @PostMapping("/wxPay")
    public R<Map<String, String>> wxPay(@RequestBody PayPageDto payPageDto,HttpServletResponse response){
        return testWxPayService.wxPay(payPageDto, response);
    }

    @ApiOperation(value = "h5微行支付-统一下单", notes = "h5微行支付-统一下单", httpMethod = "POST")
    @ApiImplicitParam(name = "payPageDto", value = "支付入参", dataType = "PayPageDto")
    @PostMapping("/h5WxPay")
    public R<String> h5WxPay(@RequestBody PayPageDto payPageDto,HttpServletRequest request, HttpServletResponse response) throws JsonProcessingException {
        return testWxPayService.h5WxPay(payPageDto,request, response);
    }

    @ApiOperation(value = "小程序-统一下单", notes = "小程序-统一下单", httpMethod = "POST")
    @ApiImplicitParam(name = "payPageDto", value = "支付入参", dataType = "PayPageDto")
    @PostMapping("/WxPayApplets")
    public R<SortedMap<String, String>> WxPayApplets(@RequestBody PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse response) throws JsonProcessingException {
        return testWxPayService.WxPayApplets(payPageDto,request, response);
    }
    /**
     * 微信回调函数
     * 支付成功后微信服务器会调用此方法
     */
    @ApiOperation(value = "微信回调函数", notes = "微信回调函数", httpMethod = "POST")
    @RequestMapping(value = "/wxPayCallBack.do")
    public void wxPayCallBack(HttpServletRequest request, HttpServletResponse response) throws Exception {
         testWxPayService.wxPayCallBack(request,response);
    }

    @ApiOperation(value = "微信支付-交易查询", notes = "微信支付-交易查询", httpMethod = "POST")
    @ApiImplicitParam(name = "out_trade_no", value = "查询参数", dataType = "String")
    @PostMapping("/queryWx")
    public R<Map<String,String>> queryWx(@Param("out_trade_no") String out_trade_no) throws Exception{
        System.out.println("out_trade_no:"+out_trade_no);
        if (StringUtils.isBlank(out_trade_no)) {
            return R.error("入参为空");
        }
         return testWxPayService.wxQuery(out_trade_no);
    }

}
