package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.Price;
import cn.wisenergy.service.app.PriceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * @author 86187
 */
@Api(tags = "价格明细")
@RestController
@RequestMapping("/price")
@Slf4j
public class PriceController {

    @Autowired
    private PriceService priceService;

    @ApiOperation(value = "获取价格明细", notes = "获取价格明细", httpMethod = "GET")
    @GetMapping("/getList")
    public R<List<Price>> getList() {
        log.info("volunteer-service[]PriceController[]getList[]input.param");

        return priceService.getList();
    }
}
