package cn.wisenergy.web.admin.controller.app;


import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.*;
import cn.wisenergy.service.app.UserLoginService;
import cn.wisenergy.web.common.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author 86187
 * @ Description: PC-用户登录
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:50
 */
@RestController
@Api(tags = "PC-用户登录")
@RequestMapping("/user/login")
@Slf4j
public class UserLoginController extends BaseController {

    @Autowired
    private UserLoginService userLoginService;

    @ApiOperation(value = "用户注册", notes = "用户注册", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "用户信息", dataType = "UserRegisterVo")
    @PostMapping("/register")
    public R<UserInfoVo> register(@RequestBody UserRegisterVo userVo) {
        log.info("volunteer-service[]UserLongController[]resetPassword[]input.param.userVo:" + userVo);

        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) ||
                StringUtils.isBlank(userVo.getPassword()) || StringUtils.isBlank(userVo.getSmCode()) ||
                null == userVo.getSource() || null == userVo.getScene()) {
            return R.error("入参为空!");
        }

        return userLoginService.register(userVo);
    }

    @ApiOperation(value = "用户验证码登录", notes = "用户验证码登录", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "用户信息", dataType = "UserLoginVo")
    @PostMapping("/loginCode")
    public R<UserInfoVo> loginCode(@RequestBody UserLoginVo userVo, HttpServletRequest request) {
        log.info("volunteer-service[]UserLongController[]loginCode[]input.param.userVo:" + userVo);

        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getCode()) ||
                null == userVo.getSource() || null == userVo.getScene()) {
            return R.error("入参为空!");
        }

        return userLoginService.loginCode(userVo,request);
    }

    @ApiOperation(value = "用户账号密码登录", notes = "用户账号密码登录", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "登录用户信息", dataType = "UserLoginVo")
    @PostMapping("/login")
    public R<UserInfoVo> login(@RequestBody UserLoginVo userVo, HttpServletRequest request) {
        log.info("volunteer-service[]UserLongController[]login[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getPassword())) {
            return R.error("入参不能为空!");
        }

        return userLoginService.login(userVo,request);
    }

    @ApiOperation(value = "用户账号密码登录--shrio测试", notes = "用户账号密码登录--shrio测试", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "登录用户信息", dataType = "UserLoginVo")
    @PostMapping("/loginTest")
    public R<UserInfoVo> loginTest(@RequestBody UserLoginVo userVo, HttpServletRequest request) throws Exception {
        log.info("volunteer-service[]UserLongController[]login[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getPassword())) {
            return R.error("入参不能为空!");
        }

        return userLoginService.loginTest(userVo,request);
    }


    @ApiOperation(value = "退出登录", notes = "退出登录", httpMethod = "POST")
    @ApiImplicitParam(name = "outVo", value = "退出用户信息", dataType = "LoginOutVo")
    @PostMapping("/loginOut")
    public R<Boolean> loginOut(@RequestBody LoginOutVo outVo) {
        log.info("volunteer-service[]UserLongController[]loginOut[]input.param.outVo:" + outVo);
        if (null == outVo || null == outVo.getUserId()) {
            return R.error("入参不能为空!");
        }


        return userLoginService.loginOut(outVo.getUserId());
    }

    @ApiOperation(value = "修改用户密码", notes = "修改用户密码", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "用户密码", dataType = "UpdatePasswordVo")
    @PostMapping("/updatePassword")
    public R<Boolean> updatePassword(@RequestBody UpdatePasswordVo userVo) {
        log.info("volunteer-service[]UserLongController[]updatePassword[]input.param.userVo:" + userVo);
        if (null == userVo || null == userVo.getUserId() || StringUtils.isBlank(userVo.getOldPassword()) ||
                StringUtils.isBlank(userVo.getNewPassword())) {
            return R.error("入参不能为空!");
        }

        return userLoginService.updatePassword(userVo);
    }

    @ApiOperation(value = "重置密码", notes = "重置密码", httpMethod = "POST")
    @PostMapping("/resetPassword")
    public R<Boolean> resetPassword(Integer userId) {
        log.info("volunteer-service[]UserLongController[]resetPassword[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参不能为空!");
        }

        return userLoginService.resetPassword(userId);
    }

    @ApiOperation(value = "短信重置密码", notes = "修改用户密码", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "用户密码", dataType = "UserLoginVo")
    @PostMapping("/smsResetPassword")
    public R<Boolean> smsResetPassword(@RequestBody UserLoginVo userVo) {
        log.info("volunteer-service[]UserLongController[]smsResetPassword[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getPassword()) ||
                null == userVo.getSource() || null == userVo.getScene()) {
            return R.error("入参不能为空!");
        }

        return userLoginService.smsResetPassword(userVo);
    }

    @ApiOperation(value = "VIP用户注册", notes = "VIP用户注册", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "vip用户信息", dataType = "UserRegisterVo")
    @PostMapping("/registerVip")
    public R<UserInfoVo> registerVip(@RequestBody UserRegisterVo userVo) {
        log.info("volunteer-service[]UserLongController[]registerVip[]input.param.userVo:" + userVo);

        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) ||
                null == userVo.getSource() || null == userVo.getScene()) {
            return R.error("入参为空!");
        }

        return userLoginService.registerVip(userVo);
    }

}
