package cn.wisenergy.web.shir.filter;

import com.alibaba.fastjson.JSONObject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.springframework.http.HttpStatus;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * 跨域配置拦截器,继承FormAuthenticationFilter
 */
public class AuthenticationFilter extends FormAuthenticationFilter {
    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        // 错误异常提示
        HttpServletResponse httpResponse = (HttpServletResponse) response;
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        String sessionId = ((HttpServletRequest) request).getHeader("sessionId");
        if (sessionId == null) {
            setHeader(httpRequest, httpResponse);
            httpResponse.setCharacterEncoding("UTF-8");
            httpResponse.setContentType("application/json");
            Map<String, Object> map = new HashMap<>();
            map.put("status", "1001");
            map.put("message", "登录已超时，请重新登录！");
            httpResponse.getWriter().write(JSONObject.toJSONString(map));
            return false;
        } else {
            return true;
        }

    }

    /**
     * 为response设置header，实现跨域
     */
    private void setHeader(HttpServletRequest request, HttpServletResponse response) {
        //跨域的header设置
        response.setHeader("Access-control-Allow-Origin", request.getHeader("Origin"));
        response.setHeader("Access-Control-Allow-Methods", request.getMethod());
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Headers", request.getHeader("Access-Control-Request-Headers"));
        //防止乱码，适用于传输JSON数据
        //Content-Type, Content-Length, Authorization, Accept, X-Requested-With , yourHeaderFeild
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        response.setStatus(HttpStatus.OK.value());
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (request instanceof HttpServletRequest) {
            if (((HttpServletRequest) request).getMethod().toUpperCase().equals("OPTIONS")) {
                return true;
            }
        }
        //小程序放行
        if(isFilter((HttpServletRequest) request)){
            return true;
        }

        return super.isAccessAllowed(request, response, mappedValue);
    }
    //判断请求头中是否带有identity（标识是小程序）
    public boolean isFilter(HttpServletRequest request) {
        return null != request.getHeader("identity") && request.getHeader("identity").equals("miniprogram");
    }
}
