package cn.wisenergy.web.shir.filter;

import cn.wisenergy.model.app.AccountInfo;
import cn.wisenergy.model.app.Staff;
import cn.wisenergy.model.app.User;
import cn.wisenergy.web.shir.cache.MySessionManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import org.apache.logging.log4j.ThreadContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class KickoutSessionControlFilter extends AccessControlFilter {
    private final Logger logger = LoggerFactory.getLogger(KickoutSessionControlFilter.class);
    private boolean kickoutAfter = false; //踢出之前登录的/之后登录的用户 默认踢出之前登录的用户
    private int maxSession = 1; //同一个帐号最大会话数 默认1

    private MySessionManager sessionManager;
    private Cache<String, Deque<Serializable>> cache;

    public void setKickoutAfter(boolean kickoutAfter) {
        this.kickoutAfter = kickoutAfter;
    }

    public void setMaxSession(int maxSession) {
        this.maxSession = maxSession;
    }

    public void setSessionManager(MySessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    //设置Cache的key的前缀
    public void setCacheManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache("shiro_redis_cache");
    }


    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        //如果是小程序，就放行
        boolean filter = isFilter((HttpServletRequest) request);
        return filter;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = getSubject(request, response);

        Map<String, Object> map = new HashMap<>();
        //判断是否登录
        if (!subject.isAuthenticated() && !subject.isRemembered()) {
            return true;
        }
        Session session = subject.getSession();

        //设置session超时时长，30分钟（1800000毫秒）
        //session.setTimeout(1800000);
        //5分钟
        session.setTimeout(300000);

        Serializable sessionId = null;
        String username = null;
        Deque<Serializable> deque = null;

        try {
            //客户端
            User user = (User) SecurityUtils.getSubject().getPrincipal();
            username = user.getPhone();
            sessionId = session.getId();
            //读取缓存，没有就存入
            deque = cache.get(username);
        } catch (Exception e) {
            try {
                //管理端
                sessionId = session.getId();
                AccountInfo accountInfo = (AccountInfo) SecurityUtils.getSubject().getPrincipal();
                username = accountInfo.getUserName();
                //读取缓存，没有就存入
                deque = cache.get(username);
            } catch (Exception en) {
                //员工端
                Staff staff = (Staff) SecurityUtils.getSubject().getPrincipal();
                username = staff.getLoginName();
                sessionId = session.getId();
                //读取缓存，没有就存入
                deque = cache.get(username);
            }
        }

        //如果此用户没有session队列，也就是还没有登录过，缓存中没有，就new一个空队列，不然deque对象为空，会报空指针
        if (deque == null) {
            deque = new LinkedList<>();
        }
        //如果队列里没有此sessionId，且用户没有被踢出；放入队列
        if (!deque.contains(sessionId) && session.getAttribute("kickout") == null) {
            //将sessionId存入队列
            deque.push(sessionId);
            //将用户的sessionId队列缓存
            cache.put(username, deque);
        }
        //如果队列里的sessionId数超出最大会话数，开始踢人
        while (deque.size() > maxSession) {
            Serializable kickoutSessionId;
            if (kickoutAfter) { //如果踢出后者
                kickoutSessionId = deque.removeFirst();
                //踢出后再更新下缓存队列
            } else { //否则踢出前者
                kickoutSessionId = deque.removeLast();
                //踢出后再更新下缓存队列
            }
            cache.put(username, deque);
            try {
                //获取被踢出的sessionId的session对象
                DefaultSessionKey defaultSessionKey = new DefaultSessionKey(kickoutSessionId);
                Session kickoutSession = sessionManager.getSession(defaultSessionKey);
                //Session kickoutSession = (Session) sessionManager.getSession(String.valueOf(new DefaultSessionKey(kickoutSessionId)));
                if (kickoutSession != null) {
                    //设置会话的kickout属性表示踢出了
                    kickoutSession.setAttribute("kickout", true);
                }
            } catch (Exception e) {
            }
        }
        //如果被踢出了，直接退出，重定向到踢出后的地址
        if (session.getAttribute("kickout") != null) {
            logger.info("------" + "踢出用户" + username + "登录sessionId=" + sessionId + "------");
            //会话被踢出了
            try {
                //退出登录
                subject.logout();
            } catch (Exception e) {
            }
            saveRequest(request);
            map.put("status", "1002");
            map.put("message", "您已经在其他地方登录，请重新登录。如有疑问请联系管理员！");
            out(response, map);
            return false;
        }
        return true;
    }

    private void out(ServletResponse response, Map<String, Object> map) throws IOException {
        response.setContentType("text/json");
        //设置字符集为'UTF-8'
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.write(JSON.toJSONString(map, SerializerFeature.WriteMapNullValue));
        out.flush();
        out.close();
    }

    public boolean isFilter(HttpServletRequest request) {
        return null != request.getHeader("identity") && request.getHeader("identity").equals("miniprogram");
    }


}
