package cn.wisenergy.web.shir.realm;

import cn.wisenergy.common.utils.Md5Util;
import cn.wisenergy.mapper.AccountMapper;
import cn.wisenergy.model.app.AccountInfo;
import cn.wisenergy.service.util.UserToken;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class AdminRealm extends AuthorizingRealm {
    @Autowired
    private AccountMapper accountMapper;
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UserToken userToken = (UserToken)token;
        String userName=userToken.getUsername();
        QueryWrapper<AccountInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_name", userName);
        queryWrapper.eq("is_delete", 0);
        AccountInfo accountInfo = accountMapper.selectOne(queryWrapper);
        if (accountInfo == null) {
            return null;
        }
        String password = Md5Util.digestMD5(accountInfo.getPassword());
        SimpleAuthenticationInfo authenticationInfo = new SimpleAuthenticationInfo(
                accountInfo,
                password,
                accountInfo.getUserName()
        );

        return authenticationInfo;
    }
}
