package cn.wisenergy.web.shir.realm;

import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.app.User;
import cn.wisenergy.model.enums.SourceType;
import cn.wisenergy.service.cache.RedisService;
import cn.wisenergy.service.common.CachePrefix;
import cn.wisenergy.service.util.UserToken;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class CodeRealm extends AuthorizingRealm  {
    @Autowired
    private UsersMapper usersMapper;
    @Autowired
    private RedisService redisService;
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UserToken userToken = (UserToken)token;
        String userName=userToken.getUsername();
        QueryWrapper<User> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("phone", userName);
        queryWrapper.eq("is_delete", 0);
        User userInfo = usersMapper.selectOne(queryWrapper);
        if (userInfo == null) {
            return null;
        }
        String source = SourceType.getByCode(userInfo.getSource());
        //获取短信验证码key
        String key = CachePrefix.SMS_CODE.getPrefix()  + source + "_" + userInfo.getPhone();
        String code = redisService.get(key).toString();
        SimpleAuthenticationInfo authenticationInfo = new SimpleAuthenticationInfo(
                userInfo,
                code,
                userInfo.getPhone()
        );
        return authenticationInfo;
    }
}
