package cn.wisenergy.web.shir.realm;

import cn.wisenergy.mapper.StaffMapper;
import cn.wisenergy.model.app.Staff;
import cn.wisenergy.service.util.UserToken;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class StaffRealm extends AuthorizingRealm {
    @Autowired
    private StaffMapper staffMapper;
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UserToken userToken = (UserToken)token;
        String userName=userToken.getUsername();
        QueryWrapper<Staff> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("login_name", userName);
        queryWrapper.eq("is_delete", 0);
        Staff staff = staffMapper.selectOne(queryWrapper);
        if (staff == null) {
            return null;
        }
        SimpleAuthenticationInfo authenticationInfo = new SimpleAuthenticationInfo(
                staff,
                staff.getPassword(),
                staff.getLoginName()
        );
        return authenticationInfo;
    }
}
