package cn.wisenergy.common.enums;

/**
 * 响应码基类
 *
 * @author wyy
 * @data 2019/08/15
 */
public enum RespCodeEnum {
    /********************* SpringMBoot 系统异常 **********************/
    MIS_REQ_PARAM("400", "请求参数丢失"),
    NO_AUTH_REQUEST("401", "未授权"),
    REJECT_REQUEST("403", "未授权"),
    AUTH_ERROR("40104", "权限认证失败"),
    RESOURCE_NOT_FOUND("404", "请求的资源不存在"),
    METHOD_NOT_SUPPORTED("405", "不支持的请求方法"),
    MEDIA_TYPE_NOT_ACCEPT("406", "无法接受请求中的媒体类型"),
    REQUEST_TIME_OUT("408", "无法接受请求中的媒体类型"),
    MEDIA_TYPE_NOT_SUPPORTED("415", "不支持的媒体类型"),
    SERVER_ERROR("500", "获取数据异常"),

    /* ******************** 业务自定义异常 ********************* */
    RSA_PRIVATE_KEY_ERROR("1001", "生成RSA非对称加密公钥出错"),
    RSA_NOT_EXIST("1002", "RSA非对称加密公钥不存在"),
    RSA_DECRYPTION_ERROR("1003", "RSA解密错误"),
    REQUIRED_IDENTIFY_NOT_EXIST("1005", "请求标识对象不存在"),
    ILLEGAL_PARAMETER("1006", "非法参数"),
    MISS_PARAMETER("1007", "缺少必须的参数"),
    ACCT_NOT_EXIST("1007", "账号不存在"),
    ACCT_OR_ACCOPASS_ERROR("1009", "账号或密码错误"),
    ACCT_HAS_FROZEN("1010", "账号已冻结"),
    NOT_LOGIN_ERROR("1011", "用户未登录"),
    CAPTCHA_CODE_INVALID("1012", "验证码失效"),
    CAPTCHA_CODE_ERROR("1013", "验证码错误"),
    NO_DATA("1004", "数据为空"),
    CAPTCHA_EXIST("1005", "验证码已发送，请稍等"),
    TOKEN_IS_NOT_MISSING("40101", "TOKEN无效"),
    TOKEN_IS_NOT_TIMEOUT("40102", "TOKEN超时，请检查TOKEN的有效期"),
    TOKEN_IS_NOT_ERROR("40103", "TOKEN解析异常"),
    DATA_AUTH_UNAUTHORIZED("40105", "数据权限不足"),
    USERNAME_IS_NOT_ERROR("2001", "用户名不能为空"),
    USERNAME_IS_EXIST_ERROR("2002", "用户名已存在"),
    EMPLOYEE_IS_NULL_ERROR("2003", "人员编号不能为空"),
    EMPLOYEE_IS_NOT_EXIST_ERROR("2004", "该员工不存在"),
    USER_EXIST_EMPLOYEE_ERROR("2005", "该用户已分配人员"),
    USER_IS_NOT_EXIST_ERROR("2006", "该用户不存在"),
    USER_IS_NOT_ERROR("2000", "用户不能为空");


    /**
     * 错误编码
     */
    public String code;

    /**
     * 错误编码信息
     */
    public String msg;

    /**
     * 构造函数
     *
     * @param code 编码
     * @param msg  编码信息
     */
    RespCodeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 获取编码
     */
    public String getCode() {
        return code;
    }

    /**
     * 设置编码
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 获取编码信息
     */
    public String getMsg() {
        return msg;
    }

    /**
     * 设置编码信息
     */
    public void setMsg(String msg) {
        this.msg = msg;
    }
}
