package cn.wisenergy.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class Md5Util {
    private static Logger log = LoggerFactory.getLogger(Md5Util.class);

    /**
     * MD5加密
     *
     * @param value
     * @return
     */
    public static String digestMD5(String value) {
        char[] hexDigits = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H'};
        byte[] strTemp = value.getBytes();
        MessageDigest mdTemp = null;
        try {
            mdTemp = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), e);
            return null;
        }
        mdTemp.update(strTemp);
        byte[] md = mdTemp.digest();

        int j = md.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = md[i];
            str[(k++)] = hexDigits[(byte0 >>> 4 & 0xF)];

            str[(k++)] = hexDigits[(byte0 & 0xF)];
        }
        return new String(str);
    }

    /**
     * @param len
     * @return
     * @throws Exception
     * @Title generatePassword
     * @Description: 随机生成8位密码  必须含有数字字母 特殊字符
     * @date 2018年12月11日 下午6:29:28
     * @author lut
     */
    public static String generatePassword(int len) throws Exception {
        char charr[] = "abcdefghjkmnpqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ23456789".toCharArray();
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        for (int x = 0; x < len; ++x) {
            sb.append(charr[r.nextInt(charr.length)]);
        }
        return sb.toString();
    }



}
