package cn.wisenergy.common.utils.math;

import java.text.NumberFormat;

/**
 * @ClassName MathUtil
 * @Description 计算工具类
 * @Author meng
 * @Date 2020/5/7 15:36
 * @Version 1.0
 */
public class MathUtil {

    /**
     * 计算两个数的百分比(保留小数点后两位)
     * @param num1 被除数
     * @param num2 除数
     * @return
     */
    public static String getPercent(Integer num1,Integer num2){
        if(num2  == 0){
            return "0";
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        // 设置精确到小数点后2位
        numberFormat.setMaximumFractionDigits(2);
        String str = numberFormat.format((double)num1 / (double)num2 * 100);
        return str;
    }
}
