package cn.wisenergy.mapper;

import cn.wisenergy.model.app.Banner;
import cn.wisenergy.model.app.Staff;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface StaffMapper extends BaseMapper<Banner> {
    /**
     * 禁用员工账号
     *
     * @param staffId 用户id
     * @return true 成功 false 失败
     */
    int delete(@Param("id") Integer staffId);

    /**
     * 查询员工信息集合
     * @param map 查询信息
     * @return 员工信息集合
     */
    List<Staff> getStaffList(Map<String, Object> map);

    /**
     * 编辑员工信息
     * @param staff 需要编辑的信息
     * @return true：成功 false：失败
     */
    int editStaff(Staff staff);

    /**
     * 添加员工信息
     * @param staff 需要添加的员工信息
     * @return true: 成功  false：失败
     */
    int addStaff(Staff staff);

    /**
     * 查询数据条数
     * @param map 查询参数
     * @return 数据条数
     */
    int getUserNumbers(Map<String, Object> map);

    /**
     * 查询员工信息
     * @param map 查询参数
     * @return
     */
    Staff getStaff(Map<String, Object> map);

    /**
     *
     * @param id 用户id
     * @return 用户信息
     */
    Staff getById(@Param("id") Integer id);
}
