package cn.wisenergy.model.app;

import cn.wisenergy.model.common.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 86187
 * @ Description: 价格表
 * @ Author     : 86187
 * @ Date       : 2021/1/24 9:50
 */
@Data
@ApiModel(value = "Price")

public class Price implements Serializable {
    private static final long serialVersionUID = 1112644645559505970L;

    /**
     * 价格id
     */
    @ApiModelProperty(value = "价格id", name = "id")
    private Integer id;

    /**
     * 可查询次数
     */
    @ApiModelProperty(value = "可查询次数", name = "useLimit")
    private Integer useLimit;

    /**
     * 购买需要的钱
     */
    @ApiModelProperty(value = "购买需要的钱", name = "money")
    private Integer money;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;


    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date updateTime;

    /**
     * 删除标记
     */
    @ApiModelProperty("是否删除 1,删除;0,未删除")
    private Integer isDelete;

}
