package cn.wisenergy.model.app;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import springfox.documentation.annotations.ApiIgnore;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ Description: 专业实体类
 * @ Author     : 86187
 * @ Date       : 2021/1/13 10:37
 */
@Data
@ApiModel(value = "profession")
public class Profession implements Serializable {
    private static final long serialVersionUID = 4215915155490456186L;

    /**
     * 专业id
     */
    @ApiModelProperty(value = "专业id", name = "id")
    private Integer id;

    /**
     * 方案类型：1：本科文化一批 2：本科美术一批 3：艺术本科批文学编导 4：本科体育  5：专科专业分类6：专科美术一批 7：专科文学编导一批 8：专科体育一批
     */
    @ApiModelProperty(value = "方案类型：1：本科文化一批 2：本科美术一批 3：艺术本科批文学编导 4：本科体育  5：专科专业分类6：" +
            "专科美术一批 7：专科文学编导一批 8：专科体育一批", name = "type")
    private Integer type;

    /**
     * 父id
     */
    @ApiModelProperty(value = "专业id", name = "id")
    private Integer parentId;

    /**
     * 等级
     */
    @ApiModelProperty(value = "等级", name = "level")
    private Integer level;

    /**
     * 专业名称
     */
    @ApiModelProperty(value = "专业名称", name = "name")
    private String name;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", name = "createTime")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间", name = "updateTime")
    private Date updateTime;

    /**
     * 子专业
     */
    @ApiModelProperty(value = "子专业", name = "updateTime")
    private List<Profession> children;

    /**
     * 是否选中  false : 未选中 true : 选中
     */
    @ApiModelProperty(value = "是否选中  false : 未选中 true : 选中", name = "checked")
    @TableField(exist = false)
    private Boolean checked =false;
}
