package cn.wisenergy.model.app;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 86187
 */
@Data
@ApiModel(value = "SchemeInfo")
@TableName("scheme")
public class SchemeInfo implements Serializable {
    private static final long serialVersionUID = 7020644673356401949L;
    /**
     * 方案id
     */
    @ApiModelProperty(value = "方案id", name = "id")
    private Integer id;

    /**
     * 方案名称
     */
    @ApiModelProperty(value = "方案名称", name = "schemeName")
    private String schemeName;

    /**
     * 上传时间
     */
    @ApiModelProperty(value = "上传时间", name = "uploadTime")
    private Date uploadTime;

    /**
     * 上传url
     */
    @ApiModelProperty(value = "上传时间", name = "uploadTime")
    private String fileUrl;

    /**
     * 1：本科文化一批 2：本科美术一批 3：艺术本科批文学编导
     * 4：本科体育  5：专科专业分类6：专科美术一批 7：专科文学编导一批 8：专科体育一批
     */
    @ApiModelProperty(value = "1：本科文化一批 2：本科美术一批 3：文学编导本科一批 4：本科体育  " +
            "5：专科专业分类6：专科美术一批 7：专科文学编导一批 8：专科体育一批", name = "type")
    private Integer type;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;


    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date updateTime;

    /**
     * 删除标记
     */
    @ApiModelProperty("是否删除 1,删除;0,未删除")
    private Integer isDelete;

}
