package cn.wisenergy.model.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentLoopMerge;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 充值卡子卡导出实体类dto
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
//内容高度
@ContentRowHeight(25)
//表头行高度
@HeadRowHeight(25)
//列的宽度
@ColumnWidth(25)
public class ExportCardDto implements Serializable {

    private static final long serialVersionUID = 2062796530315436172L;

    /**
     * 卡号
     */
    @ExcelProperty(value = "卡号")
    private String cardNumber;

    /**
     * 密码
     */
    @ExcelProperty(value = "密码")
    private String secretKey;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;
}
