package cn.wisenergy.model.dto;
/**
 * @ Description: 支付页面接口请求参数Dto
 * @ Author     : 86187
 * @ Date       : 2021/2/1 13:57
 */

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author 86187
 */
@Data
@ApiModel("PayPageDto")
public class PayPageDto {
    /**
     * 支付金额  ：金额不能为0
     */
    private Integer total;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 支付类型 1：支付宝 2：微信  3：充值卡
     */
    @ApiModelProperty(value = "支付类型 1：支付宝 2：微信  3：充值卡", name = "payType")
    private Integer payType;

    @ApiModelProperty(value = "微信用户的临时code",name="code")
    private String code;
}
