package cn.wisenergy.model.dto;

import cn.wisenergy.model.app.ScoreInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author 86187
 * @ Description: 用户提交Dto
 * @ Author     : 86187
 * @ Date       : 2021/1/12 15:39
 */
@Data
@ApiModel(value = "UserCommitDto")
public class UserCommitDto implements Serializable {

    private static final long serialVersionUID = 361307736335983629L;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", name = "userName")
    private String userName;

    /**
     * 用户头像
     */
    @ApiModelProperty(value = "用户头像", name = "headImage")
    private String headImage;


    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", name = "sex")
    private Integer sex;

    /**
     * 学校
     */
    @ApiModelProperty(value = "学校", name = "school")
    private String school;

    /**
     * 考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生
     */
    @ApiModelProperty(value = "考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生", name = "studentType")
    private Integer studentType;

    /**
     * 用户来源  1：PC 2：APP
     */
    @ApiModelProperty(value = "用户来源  1：PC 2：APP", name = "source")
    private Integer source;


    /**
     * 学生成绩信息
     */
    @ApiModelProperty(value = "学生成绩信息", name = "scoreInfo")
    private ScoreInfo scoreInfo;

    @ApiModelProperty(value = "flag:1:添加  2：编辑", name = "scoreInfo")
    private Integer flag;
}
