package cn.wisenergy.model.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel(value = "UserDto")
@NoArgsConstructor
@AllArgsConstructor
@Builder
//内容高度
@ContentRowHeight(25)
//表头行高度
@HeadRowHeight(25)
//列的宽度
@ColumnWidth(25)
public class UserDto implements Serializable {

    private static final long serialVersionUID = 68008573682224495L;

    /**
     * 注册时间
     */
    @ApiModelProperty(value = "注册时间", name = "registerTime")
    @ExcelProperty(value = "注册时间")
    private Date registerTime;

    /**
     * 登录来源
     */
    @ApiModelProperty(name ="source",value = "登录来源：1 PC,2 WAP")
    @ExcelProperty(value = "注册来源")
    private String source;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", name = "userName")
    @ExcelProperty(value = "用户名称")
    private String userName;

    /**
     * 性别 0：男 1：女
     */
    @ApiModelProperty(value = "性别 0：男 1：女", name = "sex")
    @ExcelProperty(value = "性别")
    private String sex;

    /**
     * 考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生
     */
    @ApiModelProperty(value = "考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生", name = "examType")
    @ExcelProperty(value = "考生类型")
    private String examType;

    /**
     * 手机
     */
    @ApiModelProperty(value = "手机号", name = "phone")
    @ExcelProperty(value = "手机号")
    private String phone;

    /**
     * 学校
     */
    @ApiModelProperty(name = "school", value = "毕业院校")
    @ExcelProperty(value = "毕业院校")
    private String school;

    /**
     * 文化成绩
     */
    @ApiModelProperty(value = "文化成绩", name = "cultureGrade")
    @ExcelProperty(value = "文化成绩")
    private String cultureGrade;

    /**
     * 专业成绩
     */
    @ApiModelProperty(value = "专业成绩", name = "majorGrade")
    @ExcelProperty(value = "专业成绩")
    private String majorGrade;

    /**
     * 用户剩余查询次数
     */
    @ApiModelProperty(value = "用户剩余查询次数", name = "queryLimit")
    @ExcelProperty(value = "用户剩余查询次数")
    private Integer queryLimit;

    /**
     * 用户微信充值总金额
     */
    @ApiModelProperty(value ="用户微信充值总金额",name = "WeChatMoney")
    @ExcelProperty(value = "用户微信充值总金额")
    private String weChatMoney;

    /**
     * 用户支付宝充值总金额
     */
    @ApiModelProperty(value ="用户支付宝充值总金额",name = "AlipayMoney")
    @ExcelProperty(value = "用户支付宝充值总金额")
    private String alipayMoney;

    /**
     * 用户充值次数
     */
    @ApiModelProperty(value ="充值卡充值总次数",name = "RechargeTimes")
    @ExcelProperty(value = "充值卡充值总次数")
    private int rechargeTimes;

    /**
     * 用户最后登陆时间
     */
    @ApiModelProperty(value = "用户最后登陆时间", name = "lastLoginTime")
    @ExcelProperty(value = "用户最后登陆时间")
    private Date lastLoginTime;
}
