package cn.wisenergy.model.dto;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ContentLoopMerge;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@Builder
@ApiModel(value = "Volunteer")
@NoArgsConstructor
@AllArgsConstructor
@ExcelIgnoreUnannotated
public class VolunteerDto implements Serializable {
    private static final long serialVersionUID = 428971334304574762L;

    /**
     * 志愿主键id
     */
    @ApiModelProperty(value = "志愿主键id", name = "id")
    private Integer id;

    /**
     * 方案类型：1：本科文化一批 2：本科美术一批 3：艺术本科批文学编导 4：本科体育  5：专科专业分类 6：专科美术一批 7：专科文学编导一批 8：专科体育一批
     */
    @ApiModelProperty(value = "方案类型：1：本科文化一批 2：本科美术一批 3：艺术本科批文学编导 4：本科体育  " +
            "5：专科专业分类 6：专科美术一批 7：专科文学编导一批 8：专科体育一批", name = "type")
    private Integer type;

    /**
     * 方案id
     */
    @ApiModelProperty(value = "方案id", name = "schemeId")
    private Integer schemeId;

    /**
     * 专业名称
     */
    @ApiModelProperty(value = "专业", name = "majorName")
    @ExcelProperty(value = "专业")
    private String majorName;

    /**
     * 院校
     */
    @ApiModelProperty(value = "院校", name = "academy")
    @ExcelProperty(value = "院校")
    private String academy;

    /**
     * 选考科目要求
     */
    @ApiModelProperty(value = "选考科目要求", name = "courseDemand")
    @ExcelProperty(value = "选考科目要求")
    private String courseDemand;

    /**
     * 学校性质
     */
    @ApiModelProperty(value = "学校性质", name = "nature")
    @ExcelProperty(value = "学校性质")
    private String nature;

    /**
     * 学年制（年）
     */
    @ApiModelProperty(value = "学年制（年）", name = "yearLimit")
    @ExcelProperty(value = "学制（年）")
    private Integer yearLimit;

    /**
     * 计划数
     */
    @ApiModelProperty(value = "计划数", name = "planNum")
    @ExcelProperty(value = "计划数")
    private Integer planNum;


    /**
     * 计划投档数
     */
    @ApiModelProperty(value = "投档计划数", name = "castArchivesNum")
    @ExcelProperty(value = "投档计划数")
    private Integer castArchivesNum;

    /**
     * 投出数
     */
    @ApiModelProperty(value = "投出数", name = "launchNum")
    @ExcelProperty(value = "投出数")
    private Integer launchNum;

    /**
     * 最低分
     */
    @ApiModelProperty(value = "参考分", name = "lowestMark")
    @ExcelProperty(value = "参考分")
    private Double lowestMark;

    /**
     * 最低位次
     */
    @ApiModelProperty(value = "最低位次", name = "lowestRank")
    @ExcelProperty(value = "最低位次")
    private String lowestRank;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;


    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date updateTime;

    /**
     * 删除标记
     */
    @ApiModelProperty("是否删除 1,删除;0,未删除")
    private Integer isDelete;

    /**
     * 方案查询时间
     */
    @ApiModelProperty(value = "方案查询时间",name = "queryTime")
    @TableField(exist = false)
    @ContentLoopMerge(eachRow = 4,columnExtend=4)
    private Date queryTime;
}
