package cn.wisenergy.model.enums;

/**
 * 充值卡状态枚举
 *
 * @author 86187
 */

public enum CardStatus {
    //未使用
    NO_USE(0, "未使用"),

    //已使用
    ALREADY_USED(1, "已使用");
    private Integer code;

    private String desc;

    CardStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDescription() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public static String getNameByCode(Integer code) {
        if (null == code) {
            return null;
        }
        for (SceneType type : SceneType.values()) {
            if (type.getCode().intValue() == code.intValue()) {
                return type.name();
            }
        }
        return null;
    }
}
