package cn.wisenergy.model.enums;

/**
 * 支付方式枚举类
 *
 * @author 86187
 */

public enum PayType {

    //支付宝
    ALI_PAY(1, "支付宝"),

    //微信
    WE_CHAT(2, "微信"),

    //充值卡
    REFILL_CARD(3, "充值卡");
    private Integer code;

    private String desc;

    PayType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDescription() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public static String getNameByCode(Integer code) {
        if (null == code) {
            return null;
        }
        for (SceneType type : SceneType.values()) {
            if (type.getCode().intValue() == code.intValue()) {
                return type.name();
            }
        }
        return null;
    }
}
