package cn.wisenergy.model.enums;

/**
 * 图片验证码业务类型
 *
 * @author zh
 * @version v2.0
 * @since v7.0
 * 2018年3月19日 下午4:35:32
 */
public enum SceneType {

    //验证码登录
    LOGIN(1, "验证码登录"),
    //手机注册
    REGISTER(2, "手机注册"),
    //修改密码
    MODIFY_PASSWORD(3, "修改密码"),
    //找回密码
    FIND_PASSWORD(4, "找回密码"),

    RESET_PASSWORD(5, "短信重置密码");
    private Integer code;

    private String desc;

    SceneType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDescription() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public static String getNameByCode(Integer code) {
        if (null == code) {
            return null;
        }
        for (SceneType type : SceneType.values()) {
            if (type.getCode().intValue() == code.intValue()) {
                return type.name();
            }
        }
        return null;
    }
}
