package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;

/**
 * @author 86187
 * @ Description: 添加用户查询次数Vo
 * @ Author     : 86187
 * @ Date       : 2021/1/27 10:19
 */
@Data
@ApiModel(value = "AddLimitVo")
public class AddLimitVo implements Serializable {
    private static final long serialVersionUID = -1402670785302226482L;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 支付类型 1：支付宝 2：微信  3：充值卡
     */
    @ApiModelProperty(value = "支付类型 1：支付宝 2：微信  3：充值卡", name = "payType")
    private Integer payType;

    /**
     * 支付金额
     */
    @ApiModelProperty(value = "支付金额", name = "payMoney")
    private Integer payMoney;

    /**
     * 充值卡密码
     */
    @ApiModelProperty(value = "充值卡密码", name = "password")
    private String password;

    /**
     * 支付交易号
     */
    @ApiModelProperty(value = "支付交易号", name = "tradeNo")
    private String tradeNo;
}
