package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author 86187
 * @ Description: 方案查询Vo
 * @ Author     : 86187
 * @ Date       : 2021/1/13 14:53
 */
@Data
@ApiModel(value = "SchemeQueryVo")
public class SchemeVo implements Serializable {

    private static final long serialVersionUID = 717382532110305837L;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 大专业名称
     */
    @ApiModelProperty(value = "大专业名称：如 ‘法学、文学、外语’", name = "bigMajorNames")
    private String bigMajorNames;

    /**
     * 专业ids
     */
    @ApiModelProperty(value = "专业ids,如'1,2,3,4,5,6...'", name = "professionIds")
    private String professionIds;

    /**
     * 文化课成绩
     */
    @ApiModelProperty(value = "文化课成绩", name = "cultureGrade")
    private String cultureGrade;

    /**
     * 专业课成绩
     */
    @ApiModelProperty(value = "专业课成绩", name = "majorGrade")
    private String majorGrade;

    /**
     * 是否展示全部  0:否  1：是
     */
    @ApiModelProperty(value = "是否展示全部  0:否  1：是", name = "isShowAll")
    private Integer isShowAll;


}
