package cn.wisenergy.model.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
*@ Description: 用户分页查询Vo
*@ Author     : 86187
*@ Date       : 2021/1/7 11:30
*/
@Data
@ApiModel(value = "UserQueryVo")
public class UserQueryVo implements Serializable {
    private static final long serialVersionUID = -3717746916267660740L;

    /**
     * 关键词
     */
    @ApiModelProperty(value = "关键词", name = "keyword")
    private String keyword;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间", name = "startTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间", name = "endTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 起始页
     */
    @ApiModelProperty(value = "起始页", name = "pageNo")
    private Integer pageNo;

    /**
     * 页大小
     */
    @ApiModelProperty(value = "页大小", name = "pageSize")
    private Integer pageSize;

    /**
     * 用户名称
     */
    @ApiModelProperty(value= "用户名" ,name="userName")
    private String userName;

    /**
     * 电话号码
     */
    @ApiModelProperty(name = "phone",value = "手机号")
    private String phone;

    private Integer startNum;

    private Integer endNum;
}
