package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author 86187
 * @ Description: 用户注册Vo
 * @ Author     : 86187
 * @ Date       : 2021/1/14 11:39
 */
@Data
@ApiModel(value = "UserRegisterVo")
public class UserRegisterVo implements Serializable {

    private static final long serialVersionUID = -1105034143432359192L;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码", name = "phone")
    private String phone;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码", name = "password")
    private String password;

    /**
     * 验证码
     */
    @ApiModelProperty(value = "验证码", name = "smCode")
    private String smCode;

    /**
     * 来源 1：PC 2：APP
     */
    @ApiModelProperty(value = "来源 1：PC 2：APP", name = "source")
    private Integer source;

    /**
     * 场景 1：登录 2：注册 3：修改密码 4：找回密码 5：重置密码
     */
    @ApiModelProperty(value = "场景 1：登录 2：注册 3：修改密码 4：找回密码 5：重置密码", name = "scene")
    private Integer scene;
}
