package cn.wisenergy.model.vo;

import cn.wisenergy.model.app.ScoreInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@Api("UserVipCommitVo")
public class UserVipCommitVo implements Serializable {
    private static final long serialVersionUID = -8080395072348646562L;


    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 主键id
     */
    @ApiModelProperty(name = "staffId", value = "员工id")
    private Integer staffId;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", name = "userName")
    private String userName;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码", name = "phone")
    private String phone;

    /**
     * 用户头像
     */
    @ApiModelProperty(value = "用户头像", name = "headImage")
    private String headImage;


    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", name = "sex")
    private Integer sex;

    /**
     * 学校
     */
    @ApiModelProperty(value = "学校", name = "school")
    private String school;

    /**
     * 考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生
     */
    @ApiModelProperty(value = "考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生", name = "studentType")
    private Integer studentType;

    /**
     * 用户来源  1：PC 2：APP
     */
    @ApiModelProperty(value = "用户来源  1：PC 2：APP", name = "source")
    private Integer source;


    /**
     * 学生成绩信息
     */
    @ApiModelProperty(value = "学生成绩信息", name = "scoreInfo")
    private ScoreInfo scoreInfo;

    @ApiModelProperty(value = "flag:1:添加  2：编辑", name = "scoreInfo")
    private Integer flag;
}
