package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.dto.PayPageDto;
import cn.wisenergy.model.dto.PayQueryDto;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public interface AliPayService {

    /**
     * 支付宝支付接口
     * @param payPageDto
     * @param request
     * @param httpResponse
     * @return 支付结果
     */
    R<String> doPost(PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse httpResponse);

    /***
     * 手机网页端支付宝支付接口
     * @param payPageDto
     * @param request
     * @param httpResponse
     * @return
     */
    R<String> wapAliPay(PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse httpResponse);




    /**
     * 支付宝交易查询
     * @param payQueryDto 查询参数
     * @return 查询结果
     */
    R<String> query(PayQueryDto payQueryDto);

    /***
     * 支付宝回调
     * @param response
     * @param request
     * @return
     */
    void aliPayCallBack(HttpServletResponse response, HttpServletRequest request) throws IOException, Exception;
}
