package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.RefillCard;
import cn.wisenergy.model.dto.RefillCardDto;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletResponse;


public interface RefillCardService {
    /**
     * 添加充值卡
     * @param refillCard 充值卡信息
     * @return true 成功 false 失败
     */
    R<Boolean> add(RefillCard refillCard);

    /**
     * 改变激活状态
     * @param batchNumber 充值卡批次号
     * @return true 成功 false 失败
     */
    R<Boolean> update(String batchNumber);

    /**
     * 查询充值卡信息
     * @param pageNo 当前页数
     * @param pageSize 每页显示条数
     * @return 充值卡信息结果集
     */
    R<PageInfo<RefillCardDto>> getList(Integer pageNo, Integer pageSize);

    /**
     * 生成卡片
     * @param id :充值卡id
     * @return true 成功 false 失败
     */
    R<Boolean> createCard(Integer id);

    /**
     * 导出excel
     * @param batchNumber 批次号
     * @param response
     * @return Excel数据
     */
    R<Boolean> createExcel(String batchNumber, HttpServletResponse response);
}
