package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.SendSmsVo;

/**
 * @author 86187
 * @ Description: 短信验证码接口定义
 * @ Author     : 86187
 * @ Date       : 2021/1/15 15:44
 */
public interface SendSmsSerVice {

    /**
     * 发送短信验证码
     *
     * @param sendSmsVo 入参信息
     * @return true 成功 false 失败
     * @throws Exception 异常
     */
    R<Boolean> sendSmCode(SendSmsVo sendSmsVo) throws Exception;

    /**
     * 验证手机验证码：外部调用
     *
     * @param phone  手机号码
     * @param code   手机验证码
     * @param type   场景类型 1:验证码登录 2:手机注册 3:修改密码 4：找回密码
     * @param source 来源 PC/APP
     * @return 是否通过校验 true通过，false不通过
     */
    R<Boolean> valid(String phone, String code, Integer type, String source);
}
