package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.Staff;
import cn.wisenergy.model.dto.StaffDto;
import cn.wisenergy.model.vo.QueryVo;
import cn.wisenergy.model.vo.StaffVo;
import com.github.pagehelper.PageInfo;

/**
 * 员工接口
 */
public interface StaffService {

    /**
     * 禁用员工账号
     *
     * @param staffId 用户id
     * @return true 成功 false 失败
     */
    R<Boolean> delete(Integer staffId);

    /**
     * 查询员工信息集合
     * @param queryVo 查询信息
     * @return 员工信息集合
     */
    R<PageInfo<StaffDto>> getStaffList(QueryVo queryVo);

    /**
     * 编辑员工信息
     * @param staff 需要编辑的信息
     * @return true：成功 false：失败
     */
    R<Boolean> editStaff(StaffVo staff);

    /**
     * 添加员工信息
     * @param staff 需要添加的员工信息
     * @return true: 成功  false：失败
     */
    R<Boolean> addStaff(StaffVo staff);
}
