package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.Local;
import cn.wisenergy.model.dto.UserInfoDto;
import cn.wisenergy.model.vo.AccountLoginVo;
import cn.wisenergy.model.vo.UserQueryVo;
import cn.wisenergy.model.vo.UserVipCommitVo;
import cn.wisenergy.model.vo.UserVipQueryVo;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface StaffUserVipService {

    /**
     * 员工登录
     *
     * @return true：成功 false：失败
     */
    R<Boolean> staffLogin(AccountLoginVo accountLoginVo);

    /**
     * 获取员工学生关系表
     *
     * @param userVipQueryVo 查询信息
     * @return
     */
    R<PageInfo<UserInfoDto>> getList(UserVipQueryVo userVipQueryVo);

    /**
     *  添加员工和vip客户关系
     * @param staffId 员工id
     * @param phone 手机号
     * @return true：成功 false：失败
     */
    R<Boolean> addUserByPhone(Integer staffId,String phone);

    /**
     * 获取地区列表
     * @return 地区列表
     */
    R<List<Local>> getLocal();

    /**
     * 保存vip客户和志愿关系
     * @param ids id群
     * @return true：成功 false：失败
     */
    R<Boolean> addUserVolunteer(String ids,Integer userId,String name);

    /**
     * 导出excel
     * @param queryVo 用户
     * @param response
     * @return Excel数据
     */
    R<Boolean> downExcel(UserVipQueryVo queryVo, HttpServletResponse response);
}