package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.dto.PayPageDto;
import com.fasterxml.jackson.core.JsonProcessingException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.SortedMap;


/**
 * @author chnegyan
 */
public interface TestWxPayService {
    /**
     * pc端微信支付
     * @Param 支付信息
     * @return 返回的信息
     */
    R<Map<String, String>> wxPay(PayPageDto payPageDto, HttpServletResponse response);

    /***
     * h5微信支付
     * @param payPageDto 支付信息
     * @param request 接收的数据
     * @param response 返回的信息
     * @return h5调支付的数据
     */
    R<String> h5WxPay(PayPageDto payPageDto,HttpServletRequest request,  HttpServletResponse response) throws JsonProcessingException;

    /***
     * 小程序微信支付
     * @param payPageDto 支付信息
     * @param request 接收的数据
     * @param response 返回的信息
     * @return 小程序调支付的数据
     */
    R<SortedMap<String, String>> WxPayApplets(PayPageDto payPageDto, HttpServletRequest request, HttpServletResponse response) throws JsonProcessingException;

    /***
     *支付成功回调
     * @param request 回调获取的数据
     * @param response 回调返回的数据
     */
    void wxPayCallBack(HttpServletRequest request, HttpServletResponse response) throws Exception;

    /***
     * 订单状态查询
     * @param out_trade_no 订单号
     * @return 订单状态
     */
    R<Map<String,String>> wxQuery(String out_trade_no) throws Exception;


}
