package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.UserLimit;
import cn.wisenergy.model.vo.AddLimitVo;


/**
 * @author 86187
 * @ Description: 用户查询次数接口定义
 * @ Author     : 86187
 * @ Date       : 2021/1/14 9:33
 */
public interface UserLimitService {
    /**
     * 获取用户查询次数信息
     *
     * @param userId 用户id
     * @return 用户查询次数信息
     */
    R<UserLimit> getByUserId(Integer userId);

    /**
     * 添加用户查询次数
     *
     * @param addLimitVo 参数
     * @return true  or false
     */
    R<Boolean> addLimit(AddLimitVo addLimitVo);

    /**
     * 减少用户查询次数
     *
     * @param userId 用户id
     * @return true  or false
     */
    R<Boolean> minusLimit(Integer userId);
}
