package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.UpdatePasswordVo;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserLoginVo;
import cn.wisenergy.model.vo.UserRegisterVo;

import javax.servlet.http.HttpServletRequest;

/**
 * @author 86187
 * @ Description: 用户登录
 * @ Author     : 86187
 * @ Date       : 2021/1/7 14:20
 */
public interface UserLoginService {
    /**
     * 用户注册接口
     *
     * @param userRegisterVo 用户信息
     * @return true 成功 false 失败
     */
    R<UserInfoVo> register(UserRegisterVo userRegisterVo);

    /**
     * 手机验证码登录
     *
     * @param userLoginVo 登录信息
     * @return true 成功 false 失败
     */
    R<UserInfoVo> loginCode(UserLoginVo userLoginVo);

    /**
     * 手机-密码登录
     *
     * @param userLoginVo 登录信息
     * @return true 成功 false 失败
     */
    R<UserInfoVo> login(UserLoginVo userLoginVo, HttpServletRequest request);

    /**
     * 退出登录
     *
     * @param userId 用户id
     * @return true 成功 false 失败
     */
    R<Boolean> loginOut(Integer userId);

    /**
     * 修改密码
     *
     * @param updateVo 修改密码信息
     * @return true 成功 false 失败
     */
    R<Boolean> updatePassword(UpdatePasswordVo updateVo);

    /**
     * 重置密码
     *
     * @param userId 用户id
     * @return true 成功 false 失败
     */
    R<Boolean> resetPassword(Integer userId);

    /**
     * 短信重置密码
     *
     * @param userLoginVo 登录信息
     * @return true 成功 false 失败
     */
    R<Boolean> smsResetPassword(UserLoginVo userLoginVo);

    /**
     * vip用户注册接口
     *
     * @param userRegisterVo 用户信息
     * @return true 成功 false 失败
     */
    R<UserInfoVo> registerVip(UserRegisterVo userRegisterVo);
}
