package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.User;
import cn.wisenergy.model.dto.UserCommitDto;
import cn.wisenergy.model.dto.UserInfoDto;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserQueryVo;
import cn.wisenergy.model.vo.UserShowVo;
import cn.wisenergy.model.vo.UserVipCommitVo;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @ Description: 用户接口
 * @ Author     : 86187
 * @ Date       : 2021/1/6 16:08
 */
public interface UserService {


    /**
     * 获取用户列表
     *
     * @param queryVo 查询条件
     * @return 用户列表集合
     */
    R<PageInfo<UserInfoDto>> getUserList(UserQueryVo queryVo);

    /**
     * 提交个人信息
     *
     * @param userInfo 用户信息
     * @return 用户信息
     */
    R<UserInfoVo> commitUserInfo(UserCommitDto userInfo);

    /**
     * 编辑用户信息
     *
     * @param user 用户信息
     * @return true 成功 false 失败
     */
    R<Boolean> edit(UserCommitDto user);

    /**
     * 删除用户
     *
     * @param userId 用户id
     * @return true 成功 false 失败
     */
    R<Boolean> delete(Integer userId);

    /**
     * 获取用户信息
     *
     * @param id 用户id
     * @return 用户信息
     */
    R<UserShowVo> getById(Integer id);

    /**
     * 获取用户信息
     * @param phone 电话号码
     * @return 用户信息
     */
    User getByPhone(String phone);

    /**
     * 导出excel
     * @param queryVo 用户
     * @return Excel数据
     */
    R<Boolean> createExcel(UserQueryVo queryVo, HttpServletResponse response);

    R<List<User>> test();

    /**
     * 提交vip用户信息
     * @param userInfo 用户信息
     * @return 用户相关信息
     */
    R<UserInfoVo> commitUserVipInfo(UserVipCommitVo userInfo);

    /**
     * 用户登录小程序授权
     * @param code 微信用户临时code
     * @return 授权状态
     */
    R<String> appletBinding(String code,Integer userId);

    /**
     * 通过openid获取用户信息
     * @param code 微信用户临时code
     * @return 用户信息
     */
     R<UserInfoVo> getByOpenid(String code);

    /**
     * 退出小程序，解绑
     * @param userId 用户id
     * @return 解绑状态
     */
     R<String> quitApplet(Integer userId);

}
