package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.SchemeInfo;
import cn.wisenergy.model.app.Volunteer;
import com.baomidou.mybatisplus.extension.service.IService;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @author 86187
 */
public interface VolunteerService extends IService<Volunteer> {
    /**
     * 批量添加志愿
     *
     * @param list 志愿列表信息
     * @return true 成功 false 失败
     */
    R<Boolean> batchAdd(List<Volunteer> list);

    /**
     * Excel批量添加方案志愿
     * @param file 志愿文件
     * @param type 方案类型
     * @param schemeName 方案名称
     * @param response 相应数据
     * @throws IOException 异常
     */
    void excelAdd(MultipartFile file, Integer type, String schemeName, String fileUrl,HttpServletResponse response) throws IOException;

    /**
     * Excel批量添加方案志愿
     * @param response 相应数据
     * @throws IOException 异常
     */
    void excelTemplate(HttpServletResponse response) throws IOException;

    /**
     * Excel批量添加方案志愿
     * @param file 志愿文件
     * @param response 相应数据
     * @throws IOException 异常
     */
    void ceshi(MultipartFile file, HttpServletResponse response) throws IOException;
}
